/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.internal.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sphinx.emf.Activator;
import org.eclipse.sphinx.emf.resource.BasicResourceProblemMarkerFactory;
import org.eclipse.sphinx.emf.resource.ExtendedResource;
import org.eclipse.sphinx.emf.resource.ExtendedResourceAdapterFactory;
import org.eclipse.sphinx.emf.resource.IResourceProblemMarkerFactory;
import org.eclipse.sphinx.emf.resource.XMLResourceProblemMarkerFactory;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.platform.resources.MarkerJob;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class ResourceProblemMarkerService {
    public static final String PROXY_URI_INTEGRITY_PROBLEM = "org.eclipse.sphinx.emf.proxyuriintegrityproblemmarker";
    public static ResourceProblemMarkerService INSTANCE = new ResourceProblemMarkerService();

    private ResourceProblemMarkerService() {
    }

    public void addProblemMarkers(Resource resource, IProgressMonitor monitor) {
        if (resource != null) {
            this.addProblemMarkers(Collections.singleton(resource), monitor);
        }
    }

    public void addProblemMarkers(Collection<Resource> resources, IProgressMonitor monitor) {
        Assert.isNotNull(resources);
        HashSet<Resource> resourcesWithProblems = new HashSet<Resource>();
        for (Resource resource : resources) {
            if (resource.getErrors().isEmpty() && resource.getWarnings().isEmpty()) continue;
            resourcesWithProblems.add(resource);
        }
        if (!resourcesWithProblems.isEmpty() && Platform.isRunning()) {
            HashMap<TransactionalEditingDomain, Collection<Resource>> resourcesToUpdate = new HashMap<TransactionalEditingDomain, Collection<Resource>>();
            for (Resource resource : resourcesWithProblems) {
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)resource);
                HashSet<Resource> resourcesToUpdateInEditingDomain = (HashSet<Resource>)resourcesToUpdate.get(editingDomain);
                if (resourcesToUpdateInEditingDomain == null) {
                    resourcesToUpdateInEditingDomain = new HashSet<Resource>();
                    resourcesToUpdate.put(editingDomain, resourcesToUpdateInEditingDomain);
                }
                resourcesToUpdateInEditingDomain.add(resource);
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)resourcesToUpdate.keySet().size());
            if (progress.isCanceled()) {
                return;
            }
            for (TransactionalEditingDomain editingDomain : resourcesToUpdate.keySet()) {
                this.addProblemMarkersInEditingDomain(editingDomain, resourcesToUpdate, (IProgressMonitor)progress.newChild(1));
            }
            MarkerJob.INSTANCE.schedule();
        }
    }

    public void removeProblemMarkers(Collection<IFile> files, IProgressMonitor monitor) {
        for (IFile file : files) {
            if (!file.isAccessible()) continue;
            this.getResourceProblemMarkerFactory(file).deleteMarkers((IResource)file);
        }
    }

    private void addProblemMarkersInEditingDomain(final TransactionalEditingDomain editingDomain, final Map<TransactionalEditingDomain, Collection<Resource>> resourcesToUpdate, final IProgressMonitor monitor) {
        Assert.isNotNull(resourcesToUpdate);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Collection resourcesToUpdateInEditingDomain = (Collection)resourcesToUpdate.get(editingDomain);
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)resourcesToUpdateInEditingDomain.size());
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                for (Resource resource : resourcesToUpdateInEditingDomain) {
                    IFile file = EcorePlatformUtil.getFile(resource);
                    if (file != null) {
                        Map options = ResourceProblemMarkerService.this.getProblemHandlingOptions(resource);
                        IResourceProblemMarkerFactory factory = ResourceProblemMarkerService.this.getResourceProblemMarkerFactory(resource, options);
                        int maxCount = ResourceProblemMarkerService.this.getMaxProblemMarkerCount(options);
                        int count = 0;
                        ArrayList safeErrors = new ArrayList(resource.getErrors());
                        Iterator iter = safeErrors.iterator();
                        while (iter.hasNext() && count != maxCount) {
                            try {
                                factory.createProblemMarker((IResource)file, (Resource.Diagnostic)iter.next(), 2, options);
                            }
                            catch (Exception ex) {
                                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
                            }
                            ++count;
                        }
                        ArrayList safeWarnings = new ArrayList(resource.getWarnings());
                        Iterator iter2 = safeWarnings.iterator();
                        while (iter2.hasNext() && count != maxCount) {
                            try {
                                factory.createProblemMarker((IResource)file, (Resource.Diagnostic)iter2.next(), 1, options);
                            }
                            catch (Exception ex) {
                                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
                            }
                            ++count;
                        }
                    }
                    progress.worked(1);
                    if (!progress.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
            }
        };
        if (editingDomain != null) {
            try {
                editingDomain.runExclusive(runnable);
            }
            catch (InterruptedException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)ex);
            }
        } else {
            runnable.run();
        }
    }

    private Map<Object, Object> getProblemHandlingOptions(Resource resource) {
        ExtendedResource extendedResource;
        if (resource != null && (extendedResource = ExtendedResourceAdapterFactory.INSTANCE.adapt(resource)) != null) {
            return extendedResource.getProblemHandlingOptions();
        }
        return null;
    }

    private int getMaxProblemMarkerCount(Map<Object, Object> problemHandlingOptions) {
        Object count;
        if (problemHandlingOptions != null && (count = problemHandlingOptions.get("MAX_PROBLEM_MARKER_COUNT")) instanceof Integer) {
            return (Integer)count;
        }
        return ExtendedResource.OPTION_MAX_PROBLEM_MARKER_COUNT_UNLIMITED;
    }

    private IResourceProblemMarkerFactory getResourceProblemMarkerFactory(IFile file) {
        Resource resource = EcorePlatformUtil.getResource(file);
        if (resource != null) {
            Map<Object, Object> problemHandlingOptions = this.getProblemHandlingOptions(resource);
            return this.getResourceProblemMarkerFactory(resource, problemHandlingOptions);
        }
        return this.createDefaultResourceProblemMarkerFactory();
    }

    private IResourceProblemMarkerFactory getResourceProblemMarkerFactory(Resource resource, Map<Object, Object> problemHandlingOptions) {
        Object factory;
        if (problemHandlingOptions != null && (factory = problemHandlingOptions.get("PROBLEM_MARKER_FACTORY")) instanceof IResourceProblemMarkerFactory) {
            return (IResourceProblemMarkerFactory)factory;
        }
        return this.createResourceProblemMarkerFactory(resource);
    }

    private IResourceProblemMarkerFactory createResourceProblemMarkerFactory(Resource resource) {
        if (resource instanceof XMLResource) {
            return new XMLResourceProblemMarkerFactory();
        }
        return this.createDefaultResourceProblemMarkerFactory();
    }

    private BasicResourceProblemMarkerFactory createDefaultResourceProblemMarkerFactory() {
        return new BasicResourceProblemMarkerFactory();
    }
}

