/**
 * <copyright>
 * 
 * Copyright (c) 2008-2010 See4sys and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 *     See4sys - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.emf.domain.factory;

import org.eclipse.emf.transaction.TransactionalEditingDomain;

/**
 * @since 0.7.0
 */
public interface ITransactionalEditingDomainFactoryListener {

	/**
	 * Notifies clients that an editing domain has been created.
	 * 
	 * @param editingDomain
	 *            The editing domain that has been created.
	 */
	void postCreateEditingDomain(TransactionalEditingDomain editingDomain);

	/**
	 * Notifies clients that an editing domain is about to be disposed.
	 * 
	 * @param editingDomain
	 *            The editing domain being disposed.
	 */
	void preDisposeEditingDomain(TransactionalEditingDomain editingDomain);
}
