/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.groups;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.platform.ui.fields.IField;
import org.eclipse.sphinx.platform.ui.fields.IFieldListener;
import org.eclipse.sphinx.platform.ui.fields.ListButtonsField;
import org.eclipse.sphinx.platform.ui.fields.ListField;
import org.eclipse.sphinx.platform.ui.fields.SelectionButtonField;
import org.eclipse.sphinx.platform.ui.fields.adapters.IListAdapter;
import org.eclipse.sphinx.platform.ui.groups.AbstractGroup;
import org.eclipse.sphinx.platform.ui.groups.messages.Messages;
import org.eclipse.sphinx.platform.ui.internal.Activator;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class FileSelectionGroup
extends AbstractGroup {
    protected static final String DEFAULT_SECTION_NAME = String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + ".SECTION";
    protected static final String STORE_SELECTED_FILES = "SELECTED_FILES";
    protected static final String STORE_ENABLE_BUTTON = "ENABLE_BUTTON";
    protected ListButtonsField fileListField;
    protected SelectionButtonField enableButton;
    protected Set<IFile> selectedFiles = new HashSet<IFile>();
    protected String enableText;
    protected String fileListLabel;
    protected String fileExtension;
    protected IProject project;
    private String sectionName = DEFAULT_SECTION_NAME;

    public FileSelectionGroup(String groupName, String enableText, String fileListLabel, String fileExtension, IProject project) {
        this(groupName, enableText, fileListLabel, fileExtension, project, null);
    }

    public FileSelectionGroup(String groupName, String enableText, String fileListLabel, String fileExtension, IProject project, IDialogSettings dialogSettings) {
        super(groupName, dialogSettings);
        this.enableText = enableText;
        this.fileListLabel = fileListLabel;
        this.fileExtension = fileExtension;
        this.project = project;
    }

    @Override
    protected void doCreateContent(Composite parent, final int numColumns) {
        parent.setLayout((Layout)new GridLayout(numColumns, false));
        if (this.enableText != null && this.enableText.length() > 0) {
            this.enableButton = new SelectionButtonField(32);
        }
        if (this.enableText != null && this.enableText.length() > 0) {
            this.enableButton.setLabelText(this.enableText);
            this.enableButton.setSelection(false);
            this.enableButton.fillIntoGrid(parent, numColumns);
            this.enableButton.addFieldListener(new IFieldListener(){

                @Override
                public void dialogFieldChanged(IField field) {
                    FileSelectionGroup.this.updateFileSelectionEnableState(FileSelectionGroup.this.enableButton.isSelected());
                }
            });
        }
        this.fileListField = new ListButtonsField(this.createListAdapter(parent), new String[]{Messages.button_add_label, Messages.button_remove_label}, (ILabelProvider)new LabelProvider()){

            @Override
            public int getNumberOfControls() {
                return numColumns;
            }
        };
        this.fileListField.fillIntoGrid(parent, numColumns);
        this.updateFileSelectionEnableState(false);
        if (this.enableButton == null) {
            this.fileListField.setLabelText(this.fileListLabel);
            this.updateFileSelectionEnableState(true);
        }
    }

    public void updateFileSelectionEnableState(boolean enabled) {
        if (this.fileListField != null) {
            this.fileListField.setEnabled(enabled);
        }
    }

    private IListAdapter createListAdapter(final Composite parent) {
        return new IListAdapter(){

            @Override
            public void selectionChanged(ListField field) {
            }

            @Override
            public void doubleClicked(ListField field) {
            }

            @Override
            public void customButtonPressed(ListField field, int index) {
                if (index == 0) {
                    FileSelectionGroup.this.selectFiles(parent);
                }
                if (index == 1) {
                    FileSelectionGroup.this.removeFiles();
                }
            }
        };
    }

    private void selectFiles(Composite parent) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(parent.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(Messages.title_fileSelection);
        dialog.setMessage(NLS.bind((String)Messages.desc_fileSelection, (Object)this.groupName));
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setAllowMultiple(true);
        if (this.project != null) {
            dialog.setInitialSelection((Object)this.project);
        }
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    return FileSelectionGroup.this.fileExtension.equals(((IFile)element).getFileExtension());
                }
                if (element instanceof IResource) {
                    return !ExtendedPlatform.isPlatformPrivateResource((IResource)((IResource)element));
                }
                return true;
            }
        });
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                String pluginId = Activator.getDefault().getBundle().getSymbolicName();
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object file = objectArray[n2];
                    if (!(file instanceof IFile) || ((IFile)file).exists() && !FileSelectionGroup.this.fileExtension.equals(((IFile)file).getFileExtension())) {
                        return new Status(4, pluginId, 4, NLS.bind((String)Messages.msg_fileSelectionError, (Object)FileSelectionGroup.this.groupName), null);
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        });
        if (dialog.open() == 0) {
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                this.addFile((IFile)object);
                ++n2;
            }
        }
    }

    private void removeFiles() {
        if (this.fileListField != null) {
            List<Object> selection = this.fileListField.getSelectedElements();
            this.fileListField.removeElements(selection);
            for (Object element : selection) {
                IFile fileToSuppress = null;
                for (IFile file : this.selectedFiles) {
                    if (!file.getName().equals(element.toString())) continue;
                    fileToSuppress = file;
                    break;
                }
                if (fileToSuppress == null) continue;
                this.selectedFiles.remove(fileToSuppress);
            }
        }
    }

    public void addFile(IFile file) {
        Assert.isNotNull((Object)file);
        if (this.selectedFiles != null && this.fileListField != null) {
            this.selectedFiles.add(file);
            this.fileListField.addElement(file.getName());
        }
    }

    @Override
    public void saveGroupSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            IDialogSettings section = settings.getSection(this.getSectionName());
            if (section == null) {
                section = settings.addNewSection(this.getSectionName());
            }
            Collection<IFile> files = this.getFiles();
            String[] items = new String[files.size()];
            int i = 0;
            for (IFile file : files) {
                items[i] = file.getFullPath().makeRelative().toString();
                ++i;
            }
            section.put(STORE_SELECTED_FILES, items);
            section.put(STORE_ENABLE_BUTTON, this.getEnableButtonState());
        }
    }

    @Override
    protected void loadGroupSettings() {
        IDialogSettings section;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (section = settings.getSection(this.getSectionName())) != null) {
            String[] items = section.getArray(STORE_SELECTED_FILES);
            boolean enableCheck = section.getBoolean(STORE_ENABLE_BUTTON);
            if (items != null) {
                this.setEnabledButtonSelection(enableCheck);
                String[] stringArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    String fullPath = stringArray[n2];
                    IFile file = this.getFile(fullPath);
                    if (file != null && file.exists()) {
                        this.addFile(file);
                    }
                    ++n2;
                }
                this.updateFileSelectionEnableState(enableCheck);
            }
        }
    }

    protected IFile getFile(String fullPath) {
        Path path;
        if (fullPath != null && fullPath.length() > 0 && (path = new Path(fullPath)).segmentCount() > 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return null;
    }

    public Collection<IFile> getFiles() {
        return this.selectedFiles;
    }

    public boolean getEnableButtonState() {
        if (this.enableButton != null) {
            return this.enableButton.isSelected();
        }
        return false;
    }

    public void setEnabledButtonSelection(boolean selected) {
        if (this.enableButton != null) {
            this.enableButton.setSelection(selected);
        }
    }

    public String getSectionName() {
        return this.sectionName;
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }
}

