/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.AsyncCompareHelper;
import com.unboundid.ldap.sdk.AsyncCompareResultListener;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncTimeoutTimerTask;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ReadOnlyCompareRequest;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.ldap.sdk.UpdatableLDAPRequest;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class CompareRequest
extends UpdatableLDAPRequest
implements ReadOnlyCompareRequest,
ResponseAcceptor,
ProtocolOp {
    private static final long serialVersionUID = 6343453776330347024L;
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue();
    private ASN1OctetString assertionValue;
    private int messageID = -1;
    private String attributeName;
    private String dn;

    public CompareRequest(String dn, String attributeName, String assertionValue) {
        super(null);
        Validator.ensureNotNull(dn, attributeName, assertionValue);
        this.dn = dn;
        this.attributeName = attributeName;
        this.assertionValue = new ASN1OctetString(assertionValue);
    }

    public CompareRequest(String dn, String attributeName, byte[] assertionValue) {
        super(null);
        Validator.ensureNotNull(dn, attributeName, assertionValue);
        this.dn = dn;
        this.attributeName = attributeName;
        this.assertionValue = new ASN1OctetString(assertionValue);
    }

    public CompareRequest(DN dn, String attributeName, String assertionValue) {
        super(null);
        Validator.ensureNotNull(dn, attributeName, assertionValue);
        this.dn = dn.toString();
        this.attributeName = attributeName;
        this.assertionValue = new ASN1OctetString(assertionValue);
    }

    public CompareRequest(DN dn, String attributeName, byte[] assertionValue) {
        super(null);
        Validator.ensureNotNull(dn, attributeName, assertionValue);
        this.dn = dn.toString();
        this.attributeName = attributeName;
        this.assertionValue = new ASN1OctetString(assertionValue);
    }

    public CompareRequest(String dn, String attributeName, String assertionValue, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn, attributeName, assertionValue);
        this.dn = dn;
        this.attributeName = attributeName;
        this.assertionValue = new ASN1OctetString(assertionValue);
    }

    public CompareRequest(String dn, String attributeName, byte[] assertionValue, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn, attributeName, assertionValue);
        this.dn = dn;
        this.attributeName = attributeName;
        this.assertionValue = new ASN1OctetString(assertionValue);
    }

    public CompareRequest(DN dn, String attributeName, String assertionValue, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn, attributeName, assertionValue);
        this.dn = dn.toString();
        this.attributeName = attributeName;
        this.assertionValue = new ASN1OctetString(assertionValue);
    }

    public CompareRequest(DN dn, String attributeName, ASN1OctetString assertionValue, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn, attributeName, assertionValue);
        this.dn = dn.toString();
        this.attributeName = attributeName;
        this.assertionValue = assertionValue;
    }

    public CompareRequest(DN dn, String attributeName, byte[] assertionValue, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn, attributeName, assertionValue);
        this.dn = dn.toString();
        this.attributeName = attributeName;
        this.assertionValue = new ASN1OctetString(assertionValue);
    }

    @Override
    public String getDN() {
        return this.dn;
    }

    public void setDN(String dn) {
        Validator.ensureNotNull(dn);
        this.dn = dn;
    }

    public void setDN(DN dn) {
        Validator.ensureNotNull(dn);
        this.dn = dn.toString();
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        Validator.ensureNotNull(attributeName);
        this.attributeName = attributeName;
    }

    @Override
    public String getAssertionValue() {
        return this.assertionValue.stringValue();
    }

    @Override
    public byte[] getAssertionValueBytes() {
        return this.assertionValue.getValue();
    }

    @Override
    public ASN1OctetString getRawAssertionValue() {
        return this.assertionValue;
    }

    public void setAssertionValue(String assertionValue) {
        Validator.ensureNotNull(assertionValue);
        this.assertionValue = new ASN1OctetString(assertionValue);
    }

    public void setAssertionValue(byte[] assertionValue) {
        Validator.ensureNotNull(assertionValue);
        this.assertionValue = new ASN1OctetString(assertionValue);
    }

    public void setAssertionValue(ASN1OctetString assertionValue) {
        this.assertionValue = assertionValue;
    }

    @Override
    public byte getProtocolOpType() {
        return 110;
    }

    @Override
    public void writeTo(ASN1Buffer buffer) {
        ASN1BufferSequence requestSequence = buffer.beginSequence((byte)110);
        buffer.addOctetString(this.dn);
        ASN1BufferSequence avaSequence = buffer.beginSequence();
        buffer.addOctetString(this.attributeName);
        buffer.addElement(this.assertionValue);
        avaSequence.end();
        requestSequence.end();
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ASN1Element[] avaElements = new ASN1Element[]{new ASN1OctetString(this.attributeName), this.assertionValue};
        ASN1Element[] protocolOpElements = new ASN1Element[]{new ASN1OctetString(this.dn), new ASN1Sequence(avaElements)};
        return new ASN1Sequence(110, protocolOpElements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompareResult process(LDAPConnection connection, int depth) throws LDAPException {
        if (connection.synchronousMode()) {
            boolean autoReconnect = connection.getConnectionOptions().autoReconnect();
            return this.processSync(connection, depth, autoReconnect);
        }
        long requestTime = System.nanoTime();
        this.processAsync(connection, null);
        try {
            LDAPResponse response;
            try {
                long responseTimeout = this.getResponseTimeoutMillis(connection);
                response = responseTimeout > 0L ? this.responseQueue.poll(responseTimeout, TimeUnit.MILLISECONDS) : this.responseQueue.take();
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
                Thread.currentThread().interrupt();
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_COMPARE_INTERRUPTED.get(connection.getHostPort()), ie);
            }
            CompareResult compareResult = this.handleResponse(connection, response, requestTime, depth, false);
            return compareResult;
        }
        finally {
            connection.deregisterResponseAcceptor(this.messageID);
        }
    }

    AsyncRequestID processAsync(LDAPConnection connection, AsyncCompareResultListener resultListener) throws LDAPException {
        AsyncRequestID asyncRequestID;
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        if (resultListener == null) {
            asyncRequestID = null;
            connection.registerResponseAcceptor(this.messageID, this);
        } else {
            AsyncCompareHelper compareHelper = new AsyncCompareHelper(connection, this.messageID, resultListener, this.getIntermediateResponseListener());
            connection.registerResponseAcceptor(this.messageID, compareHelper);
            asyncRequestID = compareHelper.getAsyncRequestID();
            long timeout = this.getResponseTimeoutMillis(connection);
            if (timeout > 0L) {
                Timer timer = connection.getTimer();
                AsyncTimeoutTimerTask timerTask = new AsyncTimeoutTimerTask(compareHelper);
                timer.schedule((TimerTask)timerTask, timeout);
                asyncRequestID.setTimerTask(timerTask);
            }
        }
        try {
            Debug.debugLDAPRequest(this);
            connection.getConnectionStatistics().incrementNumCompareRequests();
            connection.sendMessage(message);
            return asyncRequestID;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            connection.deregisterResponseAcceptor(this.messageID);
            throw le;
        }
    }

    private CompareResult processSync(LDAPConnection connection, int depth, boolean allowRetry) throws LDAPException {
        LDAPResponse response;
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        try {
            connection.getConnectionInternals(true).getSocket().setSoTimeout((int)this.getResponseTimeoutMillis(connection));
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        long requestTime = System.nanoTime();
        Debug.debugLDAPRequest(this);
        connection.getConnectionStatistics().incrementNumCompareRequests();
        try {
            connection.sendMessage(message);
        }
        catch (LDAPException le) {
            CompareResult retryResult;
            Debug.debugException(le);
            if (allowRetry && (retryResult = this.reconnectAndRetry(connection, depth, le.getResultCode())) != null) {
                return retryResult;
            }
            throw le;
        }
        while (true) {
            try {
                response = connection.readResponse(this.messageID);
            }
            catch (LDAPException le) {
                CompareResult retryResult;
                Debug.debugException(le);
                if (le.getResultCode() == ResultCode.TIMEOUT && connection.getConnectionOptions().abandonOnTimeout()) {
                    connection.abandon(this.messageID, new Control[0]);
                }
                if (allowRetry && (retryResult = this.reconnectAndRetry(connection, depth, le.getResultCode())) != null) {
                    return retryResult;
                }
                throw le;
            }
            if (!(response instanceof IntermediateResponse)) break;
            IntermediateResponseListener listener = this.getIntermediateResponseListener();
            if (listener == null) continue;
            listener.intermediateResponseReturned((IntermediateResponse)response);
        }
        return this.handleResponse(connection, response, requestTime, depth, allowRetry);
    }

    private CompareResult handleResponse(LDAPConnection connection, LDAPResponse response, long requestTime, int depth, boolean allowRetry) throws LDAPException {
        CompareResult retryResult;
        if (response == null) {
            long waitTime = StaticUtils.nanosToMillis(System.nanoTime() - requestTime);
            if (connection.getConnectionOptions().abandonOnTimeout()) {
                connection.abandon(this.messageID, new Control[0]);
            }
            throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_COMPARE_CLIENT_TIMEOUT.get(waitTime, this.messageID, this.dn, connection.getHostPort()));
        }
        connection.getConnectionStatistics().incrementNumCompareResponses(System.nanoTime() - requestTime);
        if (response instanceof ConnectionClosedResponse) {
            CompareResult retryResult2;
            if (allowRetry && (retryResult2 = this.reconnectAndRetry(connection, depth, ResultCode.SERVER_DOWN)) != null) {
                return retryResult2;
            }
            ConnectionClosedResponse ccr = (ConnectionClosedResponse)response;
            String message = ccr.getMessage();
            if (message == null) {
                throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_COMPARE_RESPONSE.get(connection.getHostPort(), this.toString()));
            }
            throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_COMPARE_RESPONSE_WITH_MESSAGE.get(connection.getHostPort(), this.toString(), message));
        }
        CompareResult result = response instanceof CompareResult ? (CompareResult)response : new CompareResult((LDAPResult)response);
        if (result.getResultCode().equals(ResultCode.REFERRAL) && this.followReferrals(connection)) {
            if (depth >= connection.getConnectionOptions().getReferralHopLimit()) {
                return new CompareResult(this.messageID, ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_TOO_MANY_REFERRALS.get(), result.getMatchedDN(), result.getReferralURLs(), result.getResponseControls());
            }
            return this.followReferral(result, connection, depth);
        }
        if (allowRetry && (retryResult = this.reconnectAndRetry(connection, depth, result.getResultCode())) != null) {
            return retryResult;
        }
        return result;
    }

    private CompareResult reconnectAndRetry(LDAPConnection connection, int depth, ResultCode resultCode) {
        try {
            switch (resultCode.intValue()) {
                case 81: 
                case 84: 
                case 91: {
                    connection.reconnect();
                    return this.processSync(connection, depth, false);
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompareResult followReferral(CompareResult referralResult, LDAPConnection connection, int depth) throws LDAPException {
        for (String urlString : referralResult.getReferralURLs()) {
            LDAPURL referralURL = new LDAPURL(urlString);
            String host = referralURL.getHost();
            if (host == null) continue;
            CompareRequest compareRequest = referralURL.baseDNProvided() ? new CompareRequest(referralURL.getBaseDN(), this.attributeName, this.assertionValue, this.getControls()) : this;
            LDAPConnection referralConn = connection.getReferralConnector().getReferralConnection(referralURL, connection);
            try {
                CompareResult compareResult = compareRequest.process(referralConn, depth + 1);
                referralConn.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                referralConn.close();
                return compareResult;
            }
            catch (Throwable throwable) {
                try {
                    referralConn.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    referralConn.close();
                    throw throwable;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
        }
        return referralResult;
    }

    @Override
    @InternalUseOnly
    public void responseReceived(LDAPResponse response) throws LDAPException {
        try {
            this.responseQueue.put(response);
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.COMPARE;
    }

    @Override
    public CompareRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public CompareRequest duplicate(Control[] controls) {
        CompareRequest r = new CompareRequest(this.dn, this.attributeName, this.assertionValue.getValue(), controls);
        if (this.followReferralsInternal() != null) {
            r.setFollowReferrals(this.followReferralsInternal());
        }
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("CompareRequest(dn='");
        buffer.append(this.dn);
        buffer.append("', attr='");
        buffer.append(this.attributeName);
        buffer.append("', value='");
        buffer.append(this.assertionValue.stringValue());
        buffer.append('\'');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }

    @Override
    public void toCode(List<String> lineList, String requestID, int indentSpaces, boolean includeProcessing) {
        ArrayList<ToCodeArgHelper> constructorArgs = new ArrayList<ToCodeArgHelper>(3);
        constructorArgs.add(ToCodeArgHelper.createString(this.dn, "Entry DN"));
        constructorArgs.add(ToCodeArgHelper.createString(this.attributeName, "Attribute Name"));
        if (StaticUtils.isSensitiveToCodeAttribute(this.attributeName)) {
            constructorArgs.add(ToCodeArgHelper.createString("---redacted-value", "Assertion Value (Redacted because " + this.attributeName + " is " + "configured as a sensitive attribute)"));
        } else if (StaticUtils.isPrintableString(this.assertionValue.getValue())) {
            constructorArgs.add(ToCodeArgHelper.createString(this.assertionValue.stringValue(), "Assertion Value"));
        } else {
            constructorArgs.add(ToCodeArgHelper.createByteArray(this.assertionValue.getValue(), true, "Assertion Value"));
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, "CompareRequest", requestID + "Request", "new CompareRequest", constructorArgs);
        for (Control c : this.getControls()) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "Request.addControl", ToCodeArgHelper.createControl(c, null));
        }
        if (includeProcessing) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < indentSpaces; ++i) {
                buffer.append(' ');
            }
            String indent = buffer.toString();
            lineList.add("");
            lineList.add(indent + "try");
            lineList.add(indent + '{');
            lineList.add(indent + "  CompareResult " + requestID + "Result = connection.compare(" + requestID + "Request);");
            lineList.add(indent + "  // The compare was processed successfully.");
            lineList.add(indent + "  boolean compareMatched = " + requestID + "Result.compareMatched();");
            lineList.add(indent + '}');
            lineList.add(indent + "catch (LDAPException e)");
            lineList.add(indent + '{');
            lineList.add(indent + "  // The compare failed.  Maybe the following " + "will help explain why.");
            lineList.add(indent + "  ResultCode resultCode = e.getResultCode();");
            lineList.add(indent + "  String message = e.getMessage();");
            lineList.add(indent + "  String matchedDN = e.getMatchedDN();");
            lineList.add(indent + "  String[] referralURLs = e.getReferralURLs();");
            lineList.add(indent + "  Control[] responseControls = " + "e.getResponseControls();");
            lineList.add(indent + '}');
        }
    }
}

