/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.treefield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeVisitor;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.treefield.ITreeField;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.treefield.AbstractTreeFieldData;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractTreeField
extends AbstractFormField
implements ITreeField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractTreeField.class);
    private LookupCall m_lookupCall;
    private ITree m_tree;
    private boolean m_treeExternallyManaged;
    private boolean m_autoExpandAll;
    private P_TreeListener m_treeListener;

    @ConfigProperty(value="BOOLEAN")
    @Order(value=190.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredAutoLoad() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=200.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredAutoExpandAll() {
        return false;
    }

    @ConfigOperation
    @Order(value=190.0)
    protected void execSave(ITreeNode[] insertedNodes, ITreeNode[] updatedNodes, ITreeNode[] deletedNodes) {
    }

    @ConfigOperation
    @Order(value=200.0)
    protected void execLoadChildNodes(ITreeNode parentNode) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=210.0)
    protected void execSaveDeletedNode(ITreeNode row) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=220.0)
    protected void execSaveInsertedNode(ITreeNode row) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=230.0)
    protected void execSaveUpdatedNode(ITreeNode row) throws ProcessingException {
    }

    private Class<? extends ITree> getConfiguredTree() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        Class[] f = ConfigurationUtility.filterClasses((Class[])dca, ITree.class);
        if (f.length == 1) {
            return f[0];
        }
        Class[] classArray = f;
        int n = f.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            if (c.getDeclaringClass() != AbstractTreeField.class) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected void execChangedMasterValue(Object newMasterValue) {
        try {
            this.loadRootNode();
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setAutoExpandAll(this.getConfiguredAutoExpandAll());
        if (this.getConfiguredTree() != null) {
            try {
                this.setTreeInternal((ITree)ConfigurationUtility.newInnerInstance((Object)this, this.getConfiguredTree()));
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
        }
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (AbstractTreeField.this.m_tree != null) {
                    AbstractTreeField.this.m_tree.setEnabled(AbstractTreeField.this.isEnabled());
                }
            }
        });
    }

    @Override
    protected void initFieldInternal() throws ProcessingException {
        if (this.m_tree != null && !this.m_treeExternallyManaged) {
            this.m_tree.initTree();
        }
        if (this.getConfiguredAutoLoad()) {
            this.loadRootNode();
        }
        super.initFieldInternal();
    }

    @Override
    protected void disposeFieldInternal() {
        super.disposeFieldInternal();
        if (this.m_tree != null && !this.m_treeExternallyManaged) {
            this.m_tree.disposeTree();
        }
    }

    @Override
    public void exportFormFieldData(AbstractFormFieldData target) throws ProcessingException {
        AbstractTreeFieldData treeFieldData = (AbstractTreeFieldData)target;
        if (this.m_tree != null) {
            this.m_tree.exportTreeData(treeFieldData);
        }
    }

    @Override
    public void importFormFieldData(AbstractFormFieldData source, boolean valueChangeTriggersEnabled) throws ProcessingException {
        AbstractTreeFieldData treeFieldData = (AbstractTreeFieldData)source;
        if (treeFieldData.isValueSet() && this.m_tree != null) {
            try {
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(false);
                }
                this.m_tree.importTreeData(treeFieldData);
            }
            finally {
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(true);
                }
            }
        }
    }

    @Override
    public final ITree getTree() {
        return this.m_tree;
    }

    @Override
    public final void setTree(ITree tree, boolean externallyManaged) {
        this.m_treeExternallyManaged = externallyManaged;
        this.setTreeInternal(tree);
    }

    private void setTreeInternal(ITree tree) {
        boolean changed;
        if (this.m_tree == tree) {
            return;
        }
        if (this.m_tree != null && !this.m_treeExternallyManaged && this.m_treeListener != null) {
            this.m_tree.removeTreeListener(this.m_treeListener);
            this.m_treeListener = null;
        }
        this.m_tree = tree;
        if (this.m_tree != null && !this.m_treeExternallyManaged) {
            this.m_tree.setAutoDiscardOnDelete(false);
            this.m_treeListener = new P_TreeListener();
            this.m_tree.addTreeListener(this.m_treeListener);
        }
        if (this.m_tree != null) {
            this.m_tree.setEnabled(this.isEnabled());
        }
        if ((changed = this.propertySupport.setProperty("tree", (Object)this.m_tree)) && this.getForm() != null) {
            this.getForm().structureChanged(this);
        }
    }

    public boolean isAutoExpandAll() {
        return this.m_autoExpandAll;
    }

    public void setAutoExpandAll(boolean b) {
        this.m_autoExpandAll = b;
    }

    @Override
    public boolean isContentValid() {
        boolean b = super.isContentValid();
        if (b && this.isMandatory() && (this.getTree() == null || this.getTree().getRootNode() == null)) {
            return false;
        }
        return b;
    }

    @Override
    public void loadRootNode() throws ProcessingException {
        if (this.m_tree != null && !this.m_treeExternallyManaged) {
            this.loadChildNodes(this.m_tree.getRootNode());
        }
    }

    @Override
    public void loadChildNodes(ITreeNode parentNode) throws ProcessingException {
        if (this.m_tree != null && !this.m_treeExternallyManaged) {
            try {
                this.m_tree.setTreeChanging(true);
                this.execLoadChildNodes(parentNode);
            }
            finally {
                this.m_tree.setTreeChanging(false);
            }
        }
    }

    public ITreeNode createTreeNode() throws ProcessingException {
        P_InternalTreeNode node = new P_InternalTreeNode();
        return node;
    }

    @Override
    protected boolean execIsSaveNeeded() throws ProcessingException {
        boolean b = false;
        if (this.m_tree != null) {
            if (!b && this.m_tree.getDeletedNodeCount() > 0) {
                b = true;
            }
            if (!b && this.m_tree.getInsertedNodeCount() > 0) {
                b = true;
            }
            if (!b && this.m_tree.getUpdatedNodeCount() > 0) {
                b = true;
            }
        }
        return b;
    }

    @Override
    protected void execMarkSaved() throws ProcessingException {
        if (this.m_tree != null && !this.m_treeExternallyManaged) {
            try {
                this.m_tree.setTreeChanging(true);
                ITreeVisitor v = new ITreeVisitor(){

                    @Override
                    public boolean visit(ITreeNode node) {
                        if (!node.isStatusNonchanged()) {
                            node.setStatusInternal(0);
                            AbstractTreeField.this.m_tree.updateNode(node);
                        }
                        return true;
                    }
                };
                this.m_tree.visitNode(this.m_tree.getRootNode(), v);
                this.m_tree.clearDeletedNodes();
            }
            finally {
                this.m_tree.setTreeChanging(false);
            }
        }
    }

    @Override
    protected boolean execIsEmpty() throws ProcessingException {
        return this.m_tree == null || !(this.m_tree.isRootNodeVisible() ? this.m_tree.getRootNode() != null : this.m_tree.getRootNode() != null && this.m_tree.getRootNode().getChildNodeCount() > 0);
    }

    @Override
    public void doSave() throws ProcessingException {
        if (this.m_tree != null && !this.m_treeExternallyManaged) {
            try {
                ITreeNode node;
                this.m_tree.setTreeChanging(true);
                this.execSave(this.m_tree.getInsertedNodes(), this.m_tree.getUpdatedNodes(), this.m_tree.getDeletedNodes());
                ITreeNode[] insertedNodes = this.m_tree.getInsertedNodes();
                ITreeNode[] updatedNodes = this.m_tree.getUpdatedNodes();
                ITreeNode[] deletedNodes = this.m_tree.getDeletedNodes();
                int i = 0;
                while (i < deletedNodes.length) {
                    this.execSaveDeletedNode(deletedNodes[i]);
                    ++i;
                }
                this.m_tree.clearDeletedNodes();
                i = 0;
                while (i < insertedNodes.length) {
                    node = insertedNodes[i];
                    this.execSaveInsertedNode(node);
                    node.setStatusInternal(0);
                    this.m_tree.updateNode(node);
                    ++i;
                }
                i = 0;
                while (i < updatedNodes.length) {
                    node = insertedNodes[i];
                    this.execSaveUpdatedNode(node);
                    node.setStatusInternal(0);
                    this.m_tree.updateNode(node);
                    ++i;
                }
            }
            finally {
                this.m_tree.setTreeChanging(false);
            }
        }
        this.markSaved();
    }

    private class P_InternalTreeNode
    extends AbstractTreeNode {
        private P_InternalTreeNode() {
        }

        @Override
        public void loadChildren() throws ProcessingException {
            AbstractTreeField.this.loadChildNodes(this);
        }
    }

    private class P_TreeListener
    extends TreeAdapter {
        private P_TreeListener() {
        }

        @Override
        public void treeChanged(TreeEvent e) {
            switch (e.getType()) {
                case 10: 
                case 20: 
                case 30: {
                    AbstractTreeField.this.checkSaveNeeded();
                    AbstractTreeField.this.checkEmpty();
                }
            }
        }
    }
}

