/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.tree;

import java.net.URL;
import java.security.Permission;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.IDNDSupport;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNodeFilter;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeUIFacade;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeVisitor;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeListener;
import org.eclipse.scout.rt.shared.data.form.fields.treefield.AbstractTreeFieldData;

public interface ITree
extends IPropertyObserver,
IDNDSupport {
    public static final String PROP_TITLE = "title";
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_DRAG_ENABLED = "dragEnabled";
    public static final String PROP_ICON_ID = "iconId";
    public static final String PROP_MULTI_SELECT = "multiSelect";
    public static final String PROP_MULTI_CHECK = "multiCheck";
    public static final String PROP_CHECKABLE = "checkable";
    public static final String PROP_ROOT_NODE_VISIBLE = "rootNodeVisible";
    public static final String PROP_ROOT_HANDLES_VISIBLE = "rootHandlesVisible";
    public static final String PROP_KEY_STROKES = "keyStroks";
    public static final String PROP_SCROLL_TO_SELECTION = "scrollToSelection";

    public void initTree() throws ProcessingException;

    public void disposeTree();

    public void doHyperlinkAction(ITreeNode var1, URL var2) throws ProcessingException;

    public void requestFocus();

    public IMenu[] getMenus();

    public void setMenus(IMenu[] var1);

    public <T extends IMenu> T getMenu(Class<T> var1) throws ProcessingException;

    public boolean isScrollToSelection();

    public void setScrollToSelection(boolean var1);

    public void scrollToSelection();

    public ITreeNodeFilter[] getNodeFilters();

    public boolean hasNodeFilters();

    public void addNodeFilter(ITreeNodeFilter var1);

    public void removeNodeFilter(ITreeNodeFilter var1);

    public void applyNodeFilters();

    public ITreeNode getRootNode();

    public void setRootNode(ITreeNode var1);

    public String getTitle();

    public void setTitle(String var1);

    public String getIconId();

    public void setIconId(String var1);

    public String getPathText(ITreeNode var1);

    public String getPathText(ITreeNode var1, String var2);

    public ITreeNode resolveVirtualNode(ITreeNode var1) throws ProcessingException;

    public ITreeNode[] resolveVirtualNodes(ITreeNode[] var1) throws ProcessingException;

    public boolean isAutoTitle();

    public void setAutoTitle(boolean var1);

    public boolean isDragEnabled();

    public void setDragEnabled(boolean var1);

    public ITreeNode findNode(Object var1);

    public ITreeNode[] findNodes(Object[] var1);

    public boolean isRootNodeVisible();

    public void setRootNodeVisible(boolean var1);

    public boolean isRootHandlesVisible();

    public void setRootHandlesVisible(boolean var1);

    public void ensureVisible(ITreeNode var1);

    public void expandAll(ITreeNode var1);

    public void collapseAll(ITreeNode var1);

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public boolean isEnabledGranted();

    public void setEnabledGranted(boolean var1);

    public void setEnabledPermission(Permission var1);

    public int getSelectedNodeCount();

    public ITreeNode getSelectedNode();

    public ITreeNode[] getSelectedNodes();

    public boolean isSelectedNode(ITreeNode var1);

    public void selectNode(ITreeNode var1);

    public void selectNode(ITreeNode var1, boolean var2);

    public void selectNodes(ITreeNode[] var1, boolean var2);

    public void deselectNode(ITreeNode var1);

    public void deselectNodes(ITreeNode[] var1);

    public void selectPreviousNode();

    public void selectNextNode();

    public void selectFirstNode();

    public void selectLastNode();

    public void selectNextChildNode();

    public void selectPreviousParentNode();

    public ITreeNode[] getCheckedNodes();

    public boolean isAncestorNodeOf(ITreeNode var1, ITreeNode var2);

    public void addTreeListener(TreeListener var1);

    public void removeTreeListener(TreeListener var1);

    public void addUITreeListener(TreeListener var1);

    public boolean isMultiSelect();

    public void setMultiSelect(boolean var1);

    public boolean isMultiCheck();

    public void setMultiCheck(boolean var1);

    public boolean isCheckable();

    public void setCheckable(boolean var1);

    public boolean isAutoDiscardOnDelete();

    public void setAutoDiscardOnDelete(boolean var1);

    public boolean isTreeChanging();

    public void setTreeChanging(boolean var1);

    public boolean isNodeExpanded(ITreeNode var1);

    public void setNodeExpanded(ITreeNode var1, boolean var2);

    public void setNodeEnabledPermission(ITreeNode var1, Permission var2);

    public boolean isNodeEnabled(ITreeNode var1);

    public void setNodeEnabled(ITreeNode var1, boolean var2);

    public boolean isNodeEnabledGranted(ITreeNode var1);

    public void setNodeEnabledGranted(ITreeNode var1, boolean var2);

    public void setNodeVisiblePermission(ITreeNode var1, Permission var2);

    public boolean isNodeVisible(ITreeNode var1);

    public void setNodeVisible(ITreeNode var1, boolean var2);

    public boolean isNodeVisibleGranted(ITreeNode var1);

    public void setNodeVisibleGranted(ITreeNode var1, boolean var2);

    public boolean isNodeLeaf(ITreeNode var1);

    public void setNodeLeaf(ITreeNode var1, boolean var2);

    public void setNodeChecked(ITreeNode var1, boolean var2);

    public boolean isNodeChecked(ITreeNode var1);

    public int getNodeStatus(ITreeNode var1);

    public void setNodeStatus(ITreeNode var1, int var2);

    public IKeyStroke[] getKeyStrokes();

    public void setKeyStrokes(IKeyStroke[] var1);

    public void addChildNode(ITreeNode var1, ITreeNode var2);

    public void addChildNodes(ITreeNode var1, ITreeNode[] var2);

    public void addChildNode(int var1, ITreeNode var2, ITreeNode var3);

    public void addChildNodes(int var1, ITreeNode var2, ITreeNode[] var3);

    public void updateNode(ITreeNode var1);

    public void updateChildNodes(ITreeNode var1, ITreeNode[] var2);

    public void updateChildNodeOrder(ITreeNode var1, ITreeNode[] var2);

    public void removeChildNode(ITreeNode var1, ITreeNode var2);

    public void removeChildNodes(ITreeNode var1, ITreeNode[] var2);

    public void removeAllChildNodes(ITreeNode var1);

    public void removeNode(ITreeNode var1);

    public void clearDeletedNodes();

    public int getDeletedNodeCount();

    public ITreeNode[] getDeletedNodes();

    public int getInsertedNodeCount();

    public ITreeNode[] getInsertedNodes();

    public int getUpdatedNodeCount();

    public ITreeNode[] getUpdatedNodes();

    public boolean visitTree(ITreeVisitor var1);

    public boolean visitVisibleTree(ITreeVisitor var1);

    public boolean visitNode(ITreeNode var1, ITreeVisitor var2);

    public void unloadNode(ITreeNode var1) throws ProcessingException;

    public void exportTreeData(AbstractTreeFieldData var1) throws ProcessingException;

    public void importTreeData(AbstractTreeFieldData var1) throws ProcessingException;

    public IMenu[] fetchMenusForNodesInternal(ITreeNode[] var1);

    public ITreeUIFacade getUIFacade();
}

