/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columnfilter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRowFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.BooleanColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ColumnFilterForm;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ComparableColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilterManager;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.StringColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ISmartColumn;
import org.eclipse.scout.rt.shared.ScoutTexts;

public class DefaultTableColumnFilterManager
implements ITableColumnFilterManager,
ITableRowFilter {
    private final ITable m_table;
    private final Map<IColumn, ITableColumnFilter> m_filterMap;
    private boolean m_enabled;

    public DefaultTableColumnFilterManager(ITable table) {
        this.m_table = table;
        this.m_filterMap = Collections.synchronizedMap(new HashMap());
        this.setEnabled(true);
    }

    @Override
    public boolean isEnabled() {
        return this.m_enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.m_enabled != enabled) {
            this.m_enabled = enabled;
            this.m_table.removeRowFilter(this);
            if (this.m_enabled) {
                this.m_table.addRowFilter(this);
            }
        }
    }

    @Override
    public <T> ITableColumnFilter<T> getFilter(IColumn<T> col) {
        return this.m_filterMap.get(col);
    }

    @Override
    public void reset() throws ProcessingException {
        try {
            this.m_table.setTableChanging(true);
            for (IColumn col : this.m_filterMap.keySet()) {
                this.m_table.getColumnSet().updateColumn(col);
            }
            this.m_filterMap.clear();
            this.m_table.applyRowFilters();
        }
        finally {
            this.m_table.setTableChanging(false);
        }
    }

    @Override
    public void showFilterForm(IColumn col) throws ProcessingException {
        ITableColumnFilter<Boolean> filter = this.m_filterMap.get(col);
        if (filter == null) {
            if (col instanceof ISmartColumn) {
                filter = new StringColumnFilter(col);
            } else if (String.class.isAssignableFrom(col.getDataType())) {
                filter = new StringColumnFilter(col);
            } else if (Boolean.class.isAssignableFrom(col.getDataType())) {
                filter = new BooleanColumnFilter(col);
            } else if (Comparable.class.isAssignableFrom(col.getDataType())) {
                filter = new ComparableColumnFilter(col);
            }
        }
        if (filter != null) {
            ColumnFilterForm f = new ColumnFilterForm();
            f.setDisplayHint(12);
            f.setModal(true);
            f.setColumnFilter(filter);
            f.startModify();
            f.waitFor();
            if (f.isFormStored()) {
                if (filter.isEmpty()) {
                    this.m_filterMap.remove(col);
                } else {
                    this.m_filterMap.put(col, filter);
                }
                this.m_table.getColumnSet().updateColumn(col);
                this.m_table.applyRowFilters();
            }
        }
    }

    @Override
    public boolean accept(ITableRow row) {
        for (ITableColumnFilter f : this.m_filterMap.values()) {
            if (f.accept(row)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> getDisplayTexts() {
        ArrayList<String> list = new ArrayList<String>();
        for (ITableColumnFilter filter : this.m_filterMap.values()) {
            if (filter == null || filter.isEmpty()) continue;
            list.add(String.valueOf(ScoutTexts.get((String)"Column", (String[])new String[0])) + " \"" + filter.getColumn().getHeaderCell().getText() + "\"");
        }
        return list;
    }
}

