/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.servicetunnel;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.servicetunnel.IServiceTunnel;
import org.eclipse.scout.rt.client.servicetunnel.ServiceTunnelInvocationHandler;

public final class ServiceTunnelUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ServiceTunnelUtility.class);

    private ServiceTunnelUtility() {
    }

    public static <T> T createProxy(Class<T> serviceInterfaceClass, IServiceTunnel tunnel) {
        if (tunnel == null) {
            throw new IllegalArgumentException("tunnel is null");
        }
        return ServiceTunnelUtility.createProxy(serviceInterfaceClass, new ServiceTunnelInvocationHandler(serviceInterfaceClass, tunnel));
    }

    public static <T> T createProxy(Class<T> serviceInterfaceClass, InvocationHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler is null");
        }
        return (T)Proxy.newProxyInstance(serviceInterfaceClass.getClassLoader(), new Class[]{serviceInterfaceClass}, handler);
    }
}

