/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.sequencebox.internal;

import java.util.ArrayList;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.internal.GridDataBuilder;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;

public class SequenceBoxGrid {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SequenceBoxGrid.class);
    private ISequenceBox m_rangeBox = null;
    private IFormField[] m_fields;
    private int m_gridColumns;
    private int m_gridRows;

    public SequenceBoxGrid(ISequenceBox rangeBox) {
        this.m_rangeBox = rangeBox;
    }

    public void validate() {
        this.m_gridColumns = 0;
        this.m_gridRows = 0;
        ArrayList<IFormField> list = new ArrayList<IFormField>();
        IFormField[] iFormFieldArray = this.m_rangeBox.getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            if (f.isVisible()) {
                list.add(f);
            } else {
                GridData data = GridDataBuilder.createFromHints(f, 1);
                f.setGridDataInternal(data);
            }
            ++n2;
        }
        this.m_fields = list.toArray(new IFormField[list.size()]);
        this.layoutStatic();
    }

    private void layoutStatic() {
        int x = 0;
        int i = 0;
        while (i < this.m_fields.length) {
            GridData data = GridDataBuilder.createFromHints(this.m_fields[i], 1);
            data.x = x;
            data.y = 0;
            if (data.weightX < 0.0) {
                data.weightX = this.m_fields[i] instanceof IButton ? 0.0 : (double)data.w;
            }
            this.m_fields[i].setGridDataInternal(data);
            x += data.w;
            this.m_gridRows = Math.max(this.m_gridRows, data.h);
            ++i;
        }
        this.m_gridColumns = x;
    }

    public int getGridColumnCount() {
        return this.m_gridColumns;
    }

    public int getGridRowCount() {
        return this.m_gridRows;
    }
}

