/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.customizer;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.ICustomColumn;
import org.eclipse.scout.rt.shared.ScoutTexts;

public class RemoveAllCustomColumnsMenu
extends AbstractMenu {
    private final ITable m_table;

    public RemoveAllCustomColumnsMenu(ITable table) {
        this.m_table = table;
    }

    @Override
    protected String getConfiguredText() {
        return ScoutTexts.get((String)"RemoveAllCustomColumnsMenu", (String[])new String[0]);
    }

    @Override
    protected void execPrepareAction() throws ProcessingException {
        boolean visible = false;
        if (this.m_table.getTableCustomizer() != null) {
            IColumn<?>[] iColumnArray = this.m_table.getColumns();
            int n = iColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                IColumn<?> col = iColumnArray[n2];
                if (col instanceof ICustomColumn) {
                    visible = true;
                    break;
                }
                ++n2;
            }
        }
        this.setVisible(visible);
    }

    @Override
    protected void execAction() throws ProcessingException {
        if (this.m_table != null && this.m_table.getTableCustomizer() != null) {
            this.m_table.getTableCustomizer().removeAllColumns();
        }
    }
}

