/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.spellchecker.forms;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.nls.NlsUtility;
import org.eclipse.scout.rt.client.services.common.spellchecker.ISpellCheckerService;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

public class SpellCheckerLanguageLookupCall
extends LocalLookupCall {
    private static final long serialVersionUID = 1L;

    protected List<LookupRow> execCreateLookupRows() throws ProcessingException {
        TreeMap<String, LookupRow> sortMap = new TreeMap<String, LookupRow>();
        ISpellCheckerService sc = (ISpellCheckerService)SERVICES.getService(ISpellCheckerService.class);
        if (sc != null) {
            String[] stringArray = sc.getAvailableLanguages();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String lang = stringArray[n2];
                Locale loc = NlsUtility.parseLocale((String)lang);
                sortMap.put(lang, new LookupRow((Object)lang, String.valueOf(loc.getDisplayLanguage()) + " (" + loc.getDisplayCountry() + ")"));
                ++n2;
            }
        }
        return new ArrayList<LookupRow>(sortMap.values());
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

