/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.ui;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.ui.formatter.IInputValidator;
import org.eclipse.scout.nls.sdk.internal.ui.formatter.JavaFieldInputValidator;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;

public class InputValidator {
    private static final InputValidator instance = new InputValidator();

    private InputValidator() {
    }

    public static IInputValidator getNlsKeyValidator(INlsProject project) {
        return InputValidator.getNlsKeyValidator(project, new String[0]);
    }

    public static IInputValidator getNlsKeyValidator(INlsProject project, String[] exceptions) {
        return instance.getNlsKeyValidatorInternal(project, exceptions);
    }

    private IInputValidator getNlsKeyValidatorInternal(INlsProject project, String[] exceptions) {
        return new P_KeyEntryValidator(project, exceptions);
    }

    public static IInputValidator getDefaultTranslationValidator() {
        return new IInputValidator(){

            @Override
            public IStatus isValid(String value) {
                if (value.length() > 0) {
                    return Status.OK_STATUS;
                }
                return new Status(4, "org.eclipse.scout.nls.sdk", 32, "The default translation must be set.", null);
            }
        };
    }

    private class P_KeyEntryValidator
    extends JavaFieldInputValidator {
        private HashSet<String> m_keys = new HashSet();

        public P_KeyEntryValidator(INlsProject project, String[] exeptions) {
            this.m_keys = new HashSet<String>(Arrays.asList(NlsCore.getProjectKeys(project)));
            String[] stringArray = exeptions;
            int n = exeptions.length;
            int n2 = 0;
            while (n2 < n) {
                String k = stringArray[n2];
                this.m_keys.remove(k);
                ++n2;
            }
        }

        @Override
        public IStatus isValid(String value) {
            if (this.m_keys.contains(value)) {
                return new Status(4, "org.eclipse.scout.nls.sdk", 32, "A key " + value + " already exists!", null);
            }
            return super.isValid(value);
        }
    }
}

