/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.model.workspace;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;

public class NlsEntry
implements INlsEntry {
    private String m_key;
    private HashMap<Language, String> m_translations = new HashMap();
    private int m_referenceCount = -1;
    private final INlsProject m_project;

    public NlsEntry(INlsEntry row) {
        this.m_project = row.getProject();
        this.update(row);
    }

    public NlsEntry(String key, INlsProject project) {
        this.m_project = project;
        this.m_key = key;
    }

    @Override
    public INlsProject getProject() {
        return this.m_project;
    }

    @Override
    public int getType() {
        return 1;
    }

    public void update(INlsEntry refEntry) {
        this.m_translations = new HashMap();
        this.m_key = refEntry.getKey();
        for (Map.Entry<Language, String> entry : refEntry.getAllTranslations().entrySet()) {
            this.addTranslationInternal(entry.getKey(), entry.getValue());
        }
        this.m_referenceCount = refEntry.getReferenceCount();
    }

    @Override
    public String getKey() {
        return this.m_key;
    }

    @Override
    public Map<Language, String> getAllTranslations() {
        return new HashMap<Language, String>(this.m_translations);
    }

    protected void addTranslationInternal(Language language, String text) {
        if (text == null || text.equals("")) {
            text = null;
        }
        this.m_translations.put(language, text);
    }

    public void addTranslation(Language language, String text) {
        this.addTranslationInternal(language, text);
    }

    public void removeTranslation(Language language) {
        this.m_translations.remove(language);
    }

    @Override
    public String getTranslation(Language language) {
        return this.getTranslation(language, false);
    }

    @Override
    public String getTranslation(Language language, boolean defaultIfNotExist) {
        Locale locale;
        String translation = this.m_translations.get(language);
        if (translation == null && defaultIfNotExist && (translation = this.m_translations.get(new Language(locale = new Locale(language.getLocale().getLanguage(), language.getLocale().getCountry())))) == null && (translation = this.m_translations.get(new Language(locale = new Locale(locale.getLanguage())))) == null && (translation = this.m_translations.get(Language.LANGUAGE_DEFAULT)) == null) {
            translation = "!" + this.getKey() + "!";
        }
        return translation;
    }

    @Override
    public int getReferenceCount() {
        return this.m_referenceCount;
    }

    public void setReferenceCount(int refCount) {
        this.m_referenceCount = refCount;
    }

    public String toString() {
        return this.m_key;
    }

    public void setKey(String key) {
        this.m_key = key;
    }

    public boolean isEmpty() {
        for (String text : this.m_translations.values()) {
            if (text == null) continue;
            return false;
        }
        return true;
    }
}

