/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.smartfield;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.ui.smartfield.ISmartDialogListener;
import org.eclipse.scout.nls.sdk.internal.ui.smartfield.ISmartFieldListener;
import org.eclipse.scout.nls.sdk.internal.ui.smartfield.ISmartFieldModel;
import org.eclipse.scout.nls.sdk.internal.ui.smartfield.SmartDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SmartField
extends Composite {
    private Text m_text;
    private Label m_label;
    private Button m_smartButton;
    private ISmartFieldModel m_smartFieldModel;
    private SmartDialog m_smartDialog;
    private String m_lastVerifiedInput = "";
    private Font m_font;
    private Image m_smartImage;
    private List<ISmartFieldListener> m_smartFieldListenerList = new LinkedList<ISmartFieldListener>();

    public SmartField(Composite parent, int style) {
        super(parent, style);
        this.m_smartImage = NlsCore.getImage("magnifier");
        this.createComponent(this);
    }

    protected void createComponent(Composite parent) {
        this.m_smartDialog = new SmartDialog(parent.getShell());
        this.m_smartDialog.addSmartDialogListener(new ISmartDialogListener(){

            @Override
            public void itemSelected(Object item) {
                SmartField.this.m_text.setText(SmartField.this.m_smartFieldModel.getText(item));
                SmartField.this.m_lastVerifiedInput = SmartField.this.m_text.getText();
                SmartField.this.fireInputChanged(item);
            }
        });
        this.m_label = new Label(parent, 131073);
        this.m_text = new Text(parent, 2049);
        this.m_text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!SmartField.this.m_text.getText().equals(SmartField.this.m_lastVerifiedInput)) {
                    SmartField.this.handleFocusLost();
                }
            }
        });
        this.m_text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B) {
                    if (!SmartField.this.m_text.getText().equals(SmartField.this.m_lastVerifiedInput)) {
                        SmartField.this.showSmartDialog(SmartField.this.m_text.getText());
                    } else {
                        SmartField.this.showSmartDialog("");
                    }
                }
            }
        });
        this.m_smartButton = new Button(parent, 8);
        this.m_smartButton.setImage(this.m_smartImage);
        this.m_smartButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!SmartField.this.m_text.getText().equals(SmartField.this.m_lastVerifiedInput)) {
                    SmartField.this.showSmartDialog(SmartField.this.m_text.getText());
                } else {
                    SmartField.this.showSmartDialog("");
                }
            }
        });
        parent.setTabList(new Control[]{this.m_text});
        parent.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.right = new FormAttachment(40, 0);
        this.m_label.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment((Control)this.m_label, 5);
        data.bottom = new FormAttachment(100, 0);
        data.right = new FormAttachment((Control)this.m_smartButton, -2);
        this.m_text.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.right = new FormAttachment(100, 0);
        this.m_smartButton.setLayoutData((Object)data);
    }

    protected void handleFocusLost() {
        if (this.m_text.getText() == "") {
            this.fireInputChanged(null);
        } else {
            this.m_text.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SmartField.this.showSmartDialogLazy(SmartField.this.m_text.getText());
                }
            });
        }
    }

    private void fireInputChanged(Object item) {
        ArrayList<ISmartFieldListener> list = new ArrayList<ISmartFieldListener>(this.m_smartFieldListenerList);
        for (ISmartFieldListener listener : list) {
            listener.itemSelected(item);
        }
    }

    protected void showSmartDialog(String text) {
        Rectangle textBounds = this.m_text.getBounds();
        Point location = this.m_text.toDisplay(new Point(0, textBounds.height));
        Rectangle popupBounds = new Rectangle(location.x, location.y, textBounds.width, -1);
        this.m_smartDialog.open(popupBounds, text);
        this.m_smartDialog.setFocus();
    }

    protected void showSmartDialogLazy(String text) {
        Rectangle textBounds = this.m_text.getBounds();
        Point location = this.m_text.toDisplay(new Point(0, textBounds.height));
        Rectangle popupBounds = new Rectangle(location.x, location.y, textBounds.width, -1);
        this.m_smartDialog.lazyOpen(popupBounds, text);
        this.m_smartDialog.setFocus();
    }

    public void addSmartFieldListener(ISmartFieldListener listener) {
        this.m_smartFieldListenerList.add(listener);
    }

    public void removeSmartFieldListener(ISmartFieldListener listener) {
        this.m_smartFieldListenerList.remove(listener);
    }

    public void setValue(Object value) {
        this.m_text.setText(this.m_smartFieldModel.getText(value));
        this.m_lastVerifiedInput = this.m_text.getText();
    }

    public void setEnabled(boolean enabled) {
        this.m_smartButton.setEnabled(enabled);
        this.m_text.setEnabled(enabled);
    }

    public boolean getEnabled() {
        return this.m_smartButton.getEnabled();
    }

    public void setDefaultFont(Font font) {
        this.m_font = font;
        this.m_smartDialog.setFont(font);
        this.m_text.setFont(font);
        this.m_label.setFont(font);
    }

    public Font getDefaultFont() {
        return this.m_font;
    }

    public void setImage(Image image) {
        this.m_smartImage = image;
        this.m_smartButton.setImage(image);
    }

    public ISmartFieldModel getSmartFieldModel(ISmartFieldModel model) {
        return this.m_smartFieldModel;
    }

    public void setSmartFieldModel(ISmartFieldModel model) {
        this.m_smartFieldModel = model;
        this.m_smartDialog.setSmartFieldModel(model);
    }

    public void addFocusListener(FocusListener listener) {
        this.m_text.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.m_text.removeFocusListener(listener);
    }

    public void setLabel(String label) {
        this.m_label.setText(label);
    }

    public void setText(String text) {
        this.m_text.setText(text);
    }

    public String getText() {
        return this.m_text.getText();
    }

    public void setLabelFont(Font font) {
        this.m_label.setFont(font);
    }

    public Font getLabelFont() {
        return this.m_label.getFont();
    }

    public void setTextFont(Font font) {
        this.m_text.setFont(font);
    }

    public Font getTextFont() {
        return this.m_text.getFont();
    }

    public void setTextLimit(int limit) {
        this.m_text.setTextLimit(limit);
    }

    public int getTextLimit() {
        return this.m_text.getTextLimit();
    }

    public void dispose() {
        super.dispose();
        if (this.m_smartImage != null && !this.m_smartImage.isDisposed()) {
            this.m_smartImage.dispose();
        }
    }
}

