/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.dialog.nlsDirChooser;

import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.nlsDirChooser.AbstractNlsTreeItem;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.nlsDirChooser.CompareablePath;
import org.eclipse.swt.graphics.Image;

public class NlsDirChooserDialogModel
implements ITreeContentProvider,
ILabelProvider {
    private TreeSet<AbstractNlsTreeItem> m_rootFolders;
    private List<IJavaProject> m_projects;

    public NlsDirChooserDialogModel(List<IProject> projects) {
        try {
            this.m_projects = new LinkedList<IJavaProject>();
            for (IProject project : projects) {
                if (!project.hasNature("org.eclipse.pde.PluginNature") || !project.hasNature("org.eclipse.jdt.core.javanature") || !project.isOpen()) continue;
                this.m_projects.add(JavaCore.create((IProject)project));
            }
            this.load();
        }
        catch (CoreException e) {
            NlsCore.logWarning(e);
        }
    }

    private void load() throws CoreException {
        this.m_rootFolders = new TreeSet();
        for (IJavaProject project : this.m_projects) {
            IResource[] resources;
            IResource[] iResourceArray = resources = project.getProject().members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                AbstractNlsTreeItem item = this.isRelevant(resource, project);
                if (item != null) {
                    this.m_rootFolders.add(item);
                }
                ++n2;
            }
        }
    }

    private List<AbstractNlsTreeItem> getSubfolders(CompareablePath path) throws CoreException {
        LinkedList<AbstractNlsTreeItem> paths = new LinkedList<AbstractNlsTreeItem>();
        for (IJavaProject project : this.m_projects) {
            IResource[] resources;
            IFolder folder = project.getProject().getFolder(path.getPath());
            if (!folder.exists()) continue;
            IResource[] iResourceArray = resources = folder.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                AbstractNlsTreeItem item = this.isRelevant(resource, project);
                if (item != null) {
                    paths.add(item);
                }
                ++n2;
            }
        }
        return paths;
    }

    private AbstractNlsTreeItem isRelevant(IResource resource, IJavaProject project) throws CoreException {
        if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            String outputFolder = project.getOutputLocation().toString().replace(project.getProject().getName(), "").replace("/", "");
            if (outputFolder.equals(folder.getProjectRelativePath().segment(0))) {
                return null;
            }
            if (folder.getProjectRelativePath().segment(0).equals("META-INF")) {
                return null;
            }
            return new CompareablePath(resource.getProjectRelativePath());
        }
        return null;
    }

    private void ensureLoaded(CompareablePath path) {
        if (!path.isLoaded()) {
            try {
                List<AbstractNlsTreeItem> children = this.getSubfolders(path);
                for (AbstractNlsTreeItem newPath : children) {
                    path.addChild(newPath);
                }
                path.setLoaded(true);
            }
            catch (CoreException e) {
                NlsCore.logWarning(e);
            }
        }
    }

    public Object[] getChildren(Object parentElement) {
        return ((CompareablePath)parentElement).getChildren().toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        CompareablePath path = (CompareablePath)element;
        this.ensureLoaded(path);
        return path.getChildren().size() > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.m_rootFolders.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getImage(Object element) {
        return ((AbstractNlsTreeItem)element).getImage();
    }

    public String getText(Object element) {
        return ((AbstractNlsTreeItem)element).getText();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

