/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.search;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.jdt.JavaFileInputReader;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;

public abstract class AbstractNlsKeySearchRequestor
extends SearchRequestor {
    private final INlsProject m_project;

    public AbstractNlsKeySearchRequestor(INlsProject project) {
        this.m_project = project;
    }

    public final void acceptSearchMatch(SearchMatch match) throws CoreException {
        if (!(match.getResource() instanceof IFile)) {
            return;
        }
        JavaFileInputReader reader = new JavaFileInputReader((IFile)match.getResource());
        try {
            int in = -1;
            int i = 0;
            while (i < match.getOffset()) {
                in = reader.read();
                ++i;
            }
            if (reader.isCommentBlock()) {
                return;
            }
            try {
                StringBuffer buffer = new StringBuffer();
                while (in >= 0 && in != 59) {
                    in = reader.read();
                    buffer.append((char)in);
                }
                this.acceptMatch(buffer.toString(), match);
            }
            catch (IOException ex) {
                NlsCore.logError("could not read file of ICompilationUnit '" + match.getResource().getName() + "'.", ex);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                NlsCore.logError(e);
            }
        }
    }

    protected abstract void acceptMatch(String var1, SearchMatch var2);

    public INlsProject getProject() {
        return this.m_project;
    }
}

