/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.model.workspace.manifest;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.model.workspace.manifest.AbstractManifest;
import org.eclipse.scout.nls.sdk.internal.model.workspace.manifest.ManifestElement;
import org.eclipse.scout.nls.sdk.internal.model.workspace.manifest.ManifestEntry;

public class WorkspaceManifestReader
extends AbstractManifest {
    private IFile m_manifestFile;

    public WorkspaceManifestReader(IFile manifest) throws CoreException {
        super(manifest.getProject().getName(), manifest.getContents());
        this.m_manifestFile = manifest;
    }

    public WorkspaceManifestReader(IProject project) throws CoreException {
        super(project.getName(), project.getFile((IPath)new Path("META-INF/MANIFEST.MF")).getContents());
        this.m_manifestFile = project.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
    }

    @Override
    public boolean isWriteable() {
        return true;
    }

    public void addImportBundle(String bundleName, IProgressMonitor monitor) throws CoreException, IOException {
        boolean appended = false;
        String newLine = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.m_manifestFile.getContents()));
        String line = reader.readLine();
        while (line != null) {
            buffer.append(String.valueOf(line) + newLine);
            if (line.startsWith("Require-Bundle:")) {
                line = reader.readLine();
                while (line != null && line.startsWith(" ")) {
                    buffer.append(String.valueOf(line) + newLine);
                    line = reader.readLine();
                }
                int index = buffer.lastIndexOf(newLine);
                buffer.insert(index, ",");
                buffer.append(" " + bundleName + newLine);
                appended = true;
                buffer.append(line);
            }
            line = reader.readLine();
        }
        if (!appended) {
            buffer.append("Require-Bundle: " + bundleName + newLine);
        }
        buffer.append(newLine);
        this.m_manifestFile.setContents((InputStream)new ByteArrayInputStream(buffer.toString().getBytes()), true, true, monitor);
        this.m_manifestFile.refreshLocal(2, monitor);
    }

    @Override
    public IStatus store(IProgressMonitor monitor) {
        String NL = System.getProperty("line.separator");
        StringBuffer writer = new StringBuffer();
        for (String entryId : this.m_entryOrder) {
            ManifestEntry entry = (ManifestEntry)this.m_parsedEntries.get(entryId);
            writer.append(String.valueOf(entry.getKey()) + ": ");
            Iterator<ManifestElement> it = entry.getElements().iterator();
            while (it.hasNext()) {
                ManifestElement element = it.next();
                writer.append(element.getValue());
                for (Map.Entry<String, String> prop : element.getPropertyMap().entrySet()) {
                    writer.append(";" + prop.getKey() + "=" + prop.getValue());
                }
                if (it.hasNext()) {
                    writer.append("," + NL + "  ");
                    continue;
                }
                writer.append(NL);
            }
        }
        try {
            this.m_manifestFile.setContents((InputStream)new ByteArrayInputStream(writer.toString().getBytes()), true, false, monitor);
        }
        catch (CoreException e) {
            NlsCore.logWarning(e);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

