/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.jdt;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.FindReadReferencesAction;
import org.eclipse.jdt.ui.actions.FindReadReferencesInWorkingSetAction;
import org.eclipse.jdt.ui.actions.OpenNewClassWizardAction;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.jdt.NlsWorkingSet;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.NlsStatusDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;

public class NlsJdtHandler {
    public NlsJdtHandler(IFile file) {
    }

    public static CompilationUnit getCompilationUnitASTForRead(ICompilationUnit icu) {
        if (icu == null) {
            return null;
        }
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        return (CompilationUnit)parser.createAST(null);
    }

    public static List<IClasspathEntry> getSourceLocations(IJavaProject project) throws JavaModelException {
        IClasspathEntry[] clEntries;
        LinkedList<IClasspathEntry> sourceLocations = new LinkedList<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = clEntries = project.getRawClasspath();
        int n = clEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                sourceLocations.add(entry);
            }
            ++n2;
        }
        return sourceLocations;
    }

    public static boolean createFolder(IContainer folder, boolean recursively, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            NlsJdtHandler.createFolder(folder.getParent(), recursively, monitor);
            if (folder instanceof IFolder) {
                ((IFolder)folder).create(true, false, monitor);
            }
        }
        return true;
    }

    public static IType getITypeForFile(IFile file) {
        try {
            IProject project = file.getProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject jp = JavaCore.create((IProject)project);
                List<IClasspathEntry> sourceLocs = NlsJdtHandler.getSourceLocations(jp);
                String filePath = file.getProjectRelativePath().toString();
                for (IClasspathEntry entry : sourceLocs) {
                    String pref = entry.getPath().lastSegment();
                    if (!filePath.startsWith(pref)) continue;
                    filePath = filePath.substring(pref.length() + 1);
                }
                IType type = jp.findType(filePath = filePath.replace("/", ".").replaceAll(".java", ""));
                if (type == null) {
                    NlsCore.logWarning("could not find an IType for: " + file.getName());
                }
                return type;
            }
        }
        catch (Exception e) {
            NlsCore.logWarning(e);
        }
        return null;
    }

    public static boolean isDescendant(IType clazz, Class<?> superclass) throws JavaModelException {
        return NlsJdtHandler.isDescendant(clazz, superclass, null);
    }

    public static boolean isDescendant(IType clazz, Class<?> superclass, IProgressMonitor monitor) throws JavaModelException {
        IType[] types;
        IType[] iTypeArray = types = clazz.newSupertypeHierarchy(monitor).getAllSupertypes(clazz);
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (superclass.getCanonicalName().equals(type.getFullyQualifiedName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void checkJavaElement(IJavaElement element) {
        if (element == null || !element.exists()) {
            IllegalArgumentException e = new IllegalArgumentException("JavaElement must exist and not be null");
            throw e;
        }
    }

    public static void findReferences(String fullyQuallifiedField, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        NlsJdtHandler.findReferences(fullyQuallifiedField, 4, requestor, monitor);
    }

    public static void findReferences(String fullyQuallifiedField, int searchType, SearchRequestor collector, IProgressMonitor monitor) throws CoreException {
        IProject[] projects;
        LinkedList<IJavaProject> jProjects = new LinkedList<IJavaProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature") && project.hasNature("org.eclipse.pde.PluginNature")) {
                jProjects.add(JavaCore.create((IProject)project));
            }
            ++n2;
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])jProjects.toArray(new IJavaElement[jProjects.size()]), (boolean)true);
        SearchPattern pattern = SearchPattern.createPattern((String)fullyQuallifiedField, (int)searchType, (int)2, (int)0);
        SearchEngine engine = new SearchEngine();
        try {
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, collector, monitor);
        }
        catch (CoreException e) {
            NlsCore.logWarning(e);
        }
    }

    public static void findReferences(IJavaElement element, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        IProject[] projects;
        LinkedList<IJavaProject> jProjects = new LinkedList<IJavaProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature") && project.hasNature("org.eclipse.pde.PluginNature")) {
                jProjects.add(JavaCore.create((IProject)project));
            }
            ++n2;
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])jProjects.toArray(new IJavaElement[jProjects.size()]), (boolean)true);
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)element, (int)2);
        SearchEngine engine = new SearchEngine();
        try {
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, monitor);
        }
        catch (CoreException e) {
            NlsCore.logWarning(e);
        }
    }

    public static IStatus findReferencesForeground(IWorkbenchSite site, IJavaElement element, Collection<IProject> projects) {
        Object action = null;
        action = projects == null ? new FindReadReferencesAction(site) : new FindReadReferencesInWorkingSetAction(site, new IWorkingSet[]{new NlsWorkingSet(projects)});
        action.run(element);
        return Status.OK_STATUS;
    }

    public static IStatus renameField(IField field, String newName, Shell shell, IRunnableContext context) {
        try {
            RenameSupport support = RenameSupport.create((IField)field, (String)newName, (int)65);
            IStatus preCheckStatus = support.preCheck();
            if (preCheckStatus.getSeverity() == 0) {
                support.perform(shell, context);
                return Status.OK_STATUS;
            }
            new NlsStatusDialog(shell, preCheckStatus).open();
            return preCheckStatus;
        }
        catch (Exception e) {
            NlsCore.logWarning(e);
            NlsCore.logError("rename of: " + field.getElementName() + " to " + newName + " failed!", e);
            return new Status(4, "org.eclipse.scout.nls.sdk", 0, "Rename Error", (Throwable)e);
        }
    }

    public static IStatus openOrcreateJavaFile(IProject project, String name) throws CoreException {
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IType result = null;
            if (name.length() > 0) {
                result = javaProject.findType(name);
            }
            if (result != null) {
                JavaUI.openInEditor((IJavaElement)result);
            } else {
                OpenNewClassWizardAction action = new OpenNewClassWizardAction();
                action.run();
            }
            return Status.OK_STATUS;
        }
        return Status.OK_STATUS;
    }

    public static List<IPackageFragment> getPluginPackages(IProject project) {
        IJavaProject jp = JavaCore.create((IProject)project);
        return NlsJdtHandler.getPluginPackages(jp);
    }

    public static List<IPackageFragment> getPluginPackages(IJavaProject jProject) {
        LinkedList<IPackageFragment> proposals = new LinkedList<IPackageFragment>();
        try {
            IClasspathEntry[] iClasspathEntryArray = jProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = jProject.findPackageFragmentRoots(entry);
                    int n3 = iPackageFragmentRootArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragmentRoot fragRoot = iPackageFragmentRootArray[n4];
                        IJavaElement[] iJavaElementArray = fragRoot.getChildren();
                        int n5 = iJavaElementArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IJavaElement ele = iJavaElementArray[n6];
                            if (ele instanceof IPackageFragment) {
                                proposals.add((IPackageFragment)ele);
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            return proposals;
        }
        catch (JavaModelException e) {
            NlsCore.logWarning(e);
            return new LinkedList<IPackageFragment>();
        }
    }
}

