/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk;

import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.commons.nls.NlsUtility;
import org.eclipse.scout.nls.sdk.INlsIcons;
import org.eclipse.scout.nls.sdk.internal.jdt.INlsFolder;
import org.eclipse.scout.nls.sdk.internal.jdt.NlsFolder;
import org.eclipse.scout.nls.sdk.internal.model.workspace.NlsWorkspace;
import org.eclipse.scout.nls.sdk.internal.model.workspace.manifest.ManifestElement;
import org.eclipse.scout.nls.sdk.internal.model.workspace.manifest.WorkspaceManifestReader;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.model.workspace.INlsWorkspace;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class NlsCore
extends AbstractUIPlugin
implements INlsIcons {
    public static final String COLOR_NLS_ROW_INACTIVE_FOREGROUND = "nlsRowInactiveForeground";
    public static final String COLOR_TABLE_CURSOR_BACKGROUND = "color_table_cursor_background";
    public static final String COLOR_TABLE_CURSOR_FOREGROUND = "color_table_cursor_foreground";
    public static final String COLOR_TABLE_CURSOR_INACTIVE_BACKGROUND = "color_table_cursor_inactive_background";
    public static final String COLOR_TABLE_CURSOR_INACTIVE_FOREGROUND = "color_table_cursor_inactive_foreground";
    public static final String FILE_NAME_UNKNOWN = "unknown";
    public static final String PLUGIN_ID = "org.eclipse.scout.nls.sdk";
    private static NlsCore plugin;
    static String imagePath;
    private BundleContext m_context;
    private ColorRegistry m_colorRegistry;
    private INlsWorkspace m_nlsWorkspace;

    static {
        imagePath = "resources/icons/";
    }

    public void start(BundleContext context) throws Exception {
        plugin = this;
        this.m_context = context;
        this.m_colorRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        this.m_colorRegistry.put(COLOR_NLS_ROW_INACTIVE_FOREGROUND, new RGB(178, 178, 178));
        this.m_colorRegistry.put(COLOR_TABLE_CURSOR_INACTIVE_BACKGROUND, new RGB(255, 255, 255));
        this.m_colorRegistry.put(COLOR_TABLE_CURSOR_BACKGROUND, new RGB(13, 58, 161));
        this.m_colorRegistry.put(COLOR_TABLE_CURSOR_FOREGROUND, new RGB(255, 255, 255));
        this.m_colorRegistry.put(COLOR_TABLE_CURSOR_INACTIVE_FOREGROUND, new RGB(0, 0, 0));
        this.m_nlsWorkspace = new NlsWorkspace();
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.m_context = null;
        super.stop(context);
    }

    public static void log(IStatus log) {
        NlsCore.getDefault().getLog().log(log);
    }

    public static void logInfo(String message) {
        NlsCore.logInfo(message, null);
    }

    public static void logInfo(String message, Throwable t) {
        if (message == null) {
            message = "";
        }
        NlsCore.log((IStatus)new Status(1, PLUGIN_ID, message, t));
    }

    public static void logWarning(String message) {
        NlsCore.logWarning(message, null);
    }

    public static void logWarning(Throwable t) {
        NlsCore.logWarning(null, t);
    }

    public static void logWarning(String message, Throwable t) {
        if (message == null) {
            message = "";
        }
        NlsCore.log((IStatus)new Status(2, PLUGIN_ID, message, t));
    }

    public static void logError(Throwable t) {
        NlsCore.logError("", t);
    }

    public static void logError(String message) {
        NlsCore.logError(message, null);
    }

    public static void logError(String message, Throwable t) {
        if (message == null) {
            message = "";
        }
        NlsCore.log((IStatus)new Status(4, PLUGIN_ID, message, t));
    }

    public static NlsCore getDefault() {
        return plugin;
    }

    public BundleContext getBundleContext() {
        return this.m_context;
    }

    public static Image getImage(String name) {
        Image img = plugin.getImageRegistry().get(name);
        if (img == null) {
            NlsCore.getImageDescriptor(name);
        }
        return plugin.getImageRegistry().get(name);
    }

    public static Color getColor(String key) {
        return NlsCore.getDefault().m_colorRegistry.get(key);
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        ImageDescriptor desc = plugin.getImageRegistry().getDescriptor(name);
        if (desc == null) {
            desc = NlsCore.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(String.valueOf(imagePath) + name + ".gif"));
            if (desc == null) {
                desc = NlsCore.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(String.valueOf(imagePath) + name + ".png"));
            }
            if (desc == null) {
                desc = NlsCore.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(String.valueOf(imagePath) + name + ".jpg"));
            }
            if (desc == null) {
                System.err.println("could not find image for plugin: org.eclipse.scout.nls.sdk under: " + imagePath + name);
            }
            plugin.getImageRegistry().put(name, desc);
        }
        return desc;
    }

    public static List<IProject> getWorkspaceFragments(String hostPluginId) throws CoreException {
        IProject[] allProjects;
        LinkedList<IProject> fragments = new LinkedList<IProject>();
        IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement hostPluginEntry;
            WorkspaceManifestReader manifest;
            IProject lookAt = iProjectArray[n2];
            if (lookAt.isOpen() && lookAt.hasNature("org.eclipse.jdt.core.javanature") && lookAt.hasNature("org.eclipse.pde.PluginNature") && (manifest = new WorkspaceManifestReader(lookAt)).hasElement("Fragment-Host") && (hostPluginEntry = manifest.getAttribute("Fragment-Host").getFirstElement()).getValue().equals(hostPluginId)) {
                fragments.add(lookAt);
            }
            ++n2;
        }
        return fragments;
    }

    public static List<IFile> getAllTranslations(IProject toLookAt, IPath path, String fileNamePrefix) throws CoreException {
        LinkedList<IFolder> folders = new LinkedList<IFolder>();
        List<INlsFolder> nlsFolders = NlsCore.getFoldersOfProject(toLookAt, path, true);
        for (INlsFolder folder : nlsFolders) {
            folders.add(folder.getFolder());
        }
        return NlsCore.getAllTranslations(folders, fileNamePrefix);
    }

    public static List<IFile> getAllTranslations(List<IFolder> folders, String fileNamePrefix) throws CoreException {
        LinkedList<IFile> files = new LinkedList<IFile>();
        for (IFolder folder : folders) {
            IResource[] resources;
            if (!folder.exists()) continue;
            IResource[] iResourceArray = resources = folder.members(0);
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFile && resource.getName().matches(String.valueOf(fileNamePrefix) + "(_[a-zA-Z]{2}){0,3}" + "\\.properties")) {
                    files.add((IFile)resource);
                }
                ++n2;
            }
        }
        return files;
    }

    public static INlsWorkspace getNlsWorkspace() {
        return NlsCore.getDefault().getNlsWorkspaceImpl();
    }

    private INlsWorkspace getNlsWorkspaceImpl() {
        return this.m_nlsWorkspace;
    }

    public static Language getLanguage(String simpleFileName) {
        String regexp = "^[^_.]*(_([A-Za-z]{2}))?(_([A-Za-z]{2}))?(_([A-Za-z]{2}))?\\.properties$";
        Pattern p = Pattern.compile(regexp);
        Matcher matcher = p.matcher(simpleFileName);
        if (matcher.matches()) {
            String variantIso;
            String countryIso;
            if (matcher.group(2) == null) {
                return Language.LANGUAGE_DEFAULT;
            }
            String languageIso = matcher.group(2);
            if (languageIso == null) {
                languageIso = "";
            }
            if ((countryIso = matcher.group(4)) == null) {
                countryIso = "";
            }
            if ((variantIso = matcher.group(5)) == null) {
                variantIso = "";
            }
            return new Language(new Locale(languageIso, countryIso, variantIso));
        }
        return null;
    }

    public static String getLocalizedPropertiesFileName(String prefix, Language language) {
        String fileName = prefix;
        Locale locale = language.getLocale();
        fileName = String.valueOf(fileName) + "_" + locale.toString() + ".properties";
        return fileName;
    }

    public static List<INlsFolder> getFoldersOfProject(IProject project, IPath path, boolean runntimeDir) throws JavaModelException, CoreException {
        LinkedList<INlsFolder> folders = new LinkedList<INlsFolder>();
        if (project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature")) {
            IFolder foundFolder;
            if (runntimeDir) {
                IClasspathEntry[] clEntries;
                IJavaProject jp = JavaCore.create((IProject)project);
                IClasspathEntry[] iClasspathEntryArray = clEntries = jp.getRawClasspath();
                int n = clEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath toCheck;
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3 && project.getFolder(toCheck = new Path(entry.getPath().lastSegment()).append(path)).exists()) {
                        folders.add(new NlsFolder(project.getFolder(toCheck), 1));
                    }
                    ++n2;
                }
            }
            if ((foundFolder = project.getFolder(path)) != null && foundFolder.exists()) {
                folders.add(new NlsFolder(foundFolder, 4));
            }
        }
        return folders;
    }

    public static List<IProject> getProjectGroup(IProject project) throws FileNotFoundException, CoreException {
        List<IProject> anesters = NlsCore.getFragementsForProject(project);
        anesters.add(project);
        return anesters;
    }

    public static List<IProject> getFragementsForProject(IProject project) throws CoreException {
        IProject[] allProjects;
        LinkedList<IProject> anesters = new LinkedList<IProject>();
        WorkspaceManifestReader originalReader = new WorkspaceManifestReader(project);
        String originalSymbolicName = originalReader.getAttribute("Bundle-SymbolicName").getFirstElement().getValue();
        IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement hostPluginEntry;
            WorkspaceManifestReader manifest;
            IProject lookAt = iProjectArray[n2];
            if (lookAt.isOpen() && lookAt.hasNature("org.eclipse.jdt.core.javanature") && lookAt.getNature("org.eclipse.pde.PluginNature") != null && (manifest = new WorkspaceManifestReader(lookAt)).hasElement("Fragment-Host") && (hostPluginEntry = manifest.getAttribute("Fragment-Host").getFirstElement()).getValue().equals(originalSymbolicName)) {
                anesters.add(lookAt);
            }
            ++n2;
        }
        return anesters;
    }

    public static IFile getNlsFile(String pathString) {
        String[] args = pathString.split(":");
        if (args.length != 2) {
            NlsCore.logWarning("invalid parent file entry in Manifest: " + pathString + " format should be: [pluginId]:[path to *.nls file]");
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(args[0]);
        if (project == null) {
            NlsCore.logWarning("invalid project name: " + args[0]);
            return null;
        }
        IFile file = project.getFile((IPath)new Path(args[1]));
        if (file == null || !file.exists()) {
            NlsCore.logWarning("could not find file: " + args[1] + " in project " + args[0]);
            return null;
        }
        return file;
    }

    public static void dynamicBindFields(Class<?> clazz) {
        NlsUtility.dynamicBindFields(clazz);
    }

    public static String[] getProjectKeys(INlsProject project) {
        HashSet<String> collector = new HashSet<String>();
        plugin.addKeysRec(project, collector);
        return collector.toArray(new String[collector.size()]);
    }

    private void addKeysRec(INlsProject project, HashSet<String> collector) {
        if (project == null) {
            return;
        }
        String[] stringArray = project.getAllKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String k = stringArray[n2];
            collector.add(k);
            ++n2;
        }
        this.addKeysRec(project.getParent(), collector);
    }

    public static IStatus getHighestSeverityStatus(IStatus status) {
        return NlsCore.getDefault().getHighestSeverityStatusImpl(status, Status.OK_STATUS);
    }

    private IStatus getHighestSeverityStatusImpl(IStatus status, IStatus highestSeverity) {
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                highestSeverity = this.getHighestSeverityStatusImpl(child, highestSeverity);
                ++n2;
            }
            return highestSeverity;
        }
        if (highestSeverity.getSeverity() < status.getSeverity()) {
            highestSeverity = status;
        }
        return highestSeverity;
    }
}

