/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.osgi;

import java.io.Serializable;

public class BundleClassDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_bundleSymbolicName;
    private String m_className;

    public BundleClassDescriptor(String bundleSymbolicName, String className) {
        if (bundleSymbolicName == null) {
            throw new IllegalArgumentException("bundleSymbolicName must not be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("className must not be null");
        }
        this.m_bundleSymbolicName = bundleSymbolicName;
        this.m_className = className;
    }

    public String getBundleSymbolicName() {
        return this.m_bundleSymbolicName;
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getSimpleClassName() {
        int i = this.m_className.lastIndexOf(46);
        if (i >= 0) {
            return this.m_className.substring(i + 1);
        }
        return this.m_className;
    }

    public int hashCode() {
        return this.m_bundleSymbolicName.hashCode() ^ this.m_className.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BundleClassDescriptor) {
            BundleClassDescriptor o = (BundleClassDescriptor)obj;
            return o.m_bundleSymbolicName.equals(this.m_bundleSymbolicName) && o.m_className.equals(this.m_className);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.m_className + "@" + this.m_bundleSymbolicName + "]";
    }
}

