/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.logger.analysis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.logger.analysis.ILogFilter;
import org.eclipse.scout.commons.logger.analysis.LogEntry;

public class LogCategory {
    private static Pattern causePattern = Pattern.compile(".*(Caused by: .*)");
    private String severity;
    private String source;
    private String attachmentSignature;
    private ArrayList<LogEntry> m_entries = new ArrayList();

    public LogCategory(LogEntry template) {
        this.severity = template.severity;
        this.source = template.source;
        this.attachmentSignature = this.createAttachmentSignature(template.attachment);
    }

    public int getEntryCount() {
        return this.m_entries.size();
    }

    private String createAttachmentSignature(String s) {
        if (s == null) {
            return "- none -";
        }
        if ((s = s.trim()).length() == 0) {
            return "- none -";
        }
        StringBuffer buf = new StringBuffer();
        String[] stringArray = s.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Matcher m = causePattern.matcher(line);
            if (m.matches()) {
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                buf.append(m.group(1));
            }
            ++n2;
        }
        return buf.toString();
    }

    public boolean isCategoryFor(LogEntry e) {
        return this.severity.equals(e.severity) && this.source.equals(e.source) && this.attachmentSignature.equals(this.createAttachmentSignature(e.attachment));
    }

    public void add(LogEntry e) {
        this.m_entries.add(e);
    }

    public String format(ILogFilter filter) {
        StringBuffer b = new StringBuffer();
        HashSet<String> attachmentSet = new HashSet<String>();
        for (LogEntry e : this.m_entries) {
            if (e.attachment.length() <= 0) continue;
            attachmentSet.add(e.attachment);
        }
        b.append("[");
        b.append(this.severity);
        b.append("] ");
        b.append(this.source);
        b.append("\n");
        b.append(String.valueOf(this.m_entries.size()) + " occurrences");
        if (attachmentSet.size() >= 2) {
            b.append(" with " + attachmentSet.size() + " different attachments");
        }
        b.append("\n");
        b.append("*** Signature ***\n");
        b.append(this.attachmentSignature);
        b.append("\n");
        b.append("*** Headers ***\n");
        for (LogEntry e : this.m_entries) {
            b.append(filter.formatContext(e));
            b.append("\n");
        }
        b.append("*** Details ***\n");
        for (String s : attachmentSet) {
            b.append(s);
            b.append("\n");
        }
        return b.toString();
    }
}

