/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.TreeMap;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class ConfigurationUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ConfigurationUtility.class);

    private ConfigurationUtility() {
    }

    public static <T> Class<T>[] sortFilteredClassesByOrderAnnotation(Class[] classes, Class<T> filter) {
        TreeMap<CompositeObject, Class> orderedClassesMap = new TreeMap<CompositeObject, Class>();
        int i = 0;
        while (i < classes.length) {
            if (filter.isAssignableFrom(classes[i])) {
                if (classes[i].isAnnotationPresent(Order.class)) {
                    Order order = classes[i].getAnnotation(Order.class);
                    orderedClassesMap.put(new CompositeObject(order.value(), i), classes[i]);
                } else {
                    LOG.error("missing @Order annotation: " + classes[i].getName());
                    orderedClassesMap.put(new CompositeObject(Double.MAX_VALUE, i), classes[i]);
                }
            }
            ++i;
        }
        return orderedClassesMap.values().toArray(new Class[orderedClassesMap.size()]);
    }

    public static <T> Class<T> filterClass(Class[] classes, Class<T> filter) {
        Class[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            if (filter.isAssignableFrom(c) && !Modifier.isAbstract(c.getModifiers())) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public static <T> Class<T>[] filterClasses(Class[] classes, Class<T> filter) {
        ArrayList<Class> list = new ArrayList<Class>();
        Class[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            if (filter.isAssignableFrom(c) && !Modifier.isAbstract(c.getModifiers())) {
                list.add(c);
            }
            ++n2;
        }
        return list.toArray(new Class[0]);
    }

    public static Class[] getDeclaredPublicClasses(Class c) {
        return c.getClasses();
    }

    public static <T> T newInnerInstance(Object instance, Class<T> innerClass) throws Exception {
        if (innerClass.getDeclaringClass() != null) {
            Constructor<T> c = innerClass.getDeclaredConstructor(innerClass.getDeclaringClass());
            return c.newInstance(instance);
        }
        return innerClass.newInstance();
    }

    public static boolean isMethodOverwrite(Class<?> declaringType, String methodName, Class[] parameterTypes, Class<?> implementationType) {
        Method declaredMethod;
        try {
            declaredMethod = declaringType.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            LOG.error("cannot find declared method " + declaringType.getName() + "." + methodName, e);
            return false;
        }
        Class<?> c = implementationType;
        while (c != null && c != declaringType) {
            try {
                c.getDeclaredMethod(declaredMethod.getName(), declaredMethod.getParameterTypes());
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    c = c.getSuperclass();
                }
                catch (Throwable t) {
                    LOG.error("declaringType=" + declaringType + ", methodName=" + methodName + ", parameterTypes=" + parameterTypes + ", implementationType=" + implementationType, t);
                    break;
                }
            }
        }
        return false;
    }
}

