/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.nls;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class NlsResourceBundle
extends PropertyResourceBundle {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(NlsResourceBundle.class);

    public NlsResourceBundle(InputStream stream) throws IOException {
        super(stream);
    }

    public static NlsResourceBundle getBundle(String baseName, Locale locale, ClassLoader cl) {
        String ls = locale.toString();
        ArrayList<String> suffixes = new ArrayList<String>();
        suffixes.add("_" + ls);
        int i = ls.lastIndexOf(95);
        while (i >= 0) {
            ls = ls.substring(0, i);
            suffixes.add("_" + ls);
            i = ls.lastIndexOf(95);
        }
        suffixes.add("");
        NlsResourceBundle root = null;
        NlsResourceBundle child = null;
        for (String suffix : suffixes) {
            URL res = cl.getResource(String.valueOf(baseName.replace('.', '/')) + suffix + ".properties");
            if (res == null) continue;
            InputStream in = null;
            try {
                try {
                    in = res.openStream();
                    NlsResourceBundle parent = new NlsResourceBundle(in);
                    if (root == null) {
                        root = parent;
                    }
                    if (child != null) {
                        child.setParent(parent);
                    }
                    child = parent;
                }
                catch (IOException e) {
                    LOG.warn(null, e);
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {}
                }
                throw throwable;
            }
            if (in == null) continue;
            try {
                in.close();
            }
            catch (Throwable throwable) {}
        }
        return root;
    }

    public static /* bridge */ /* synthetic */ ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) {
        return NlsResourceBundle.getBundle(string, locale, classLoader);
    }
}

