/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.tab;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.pde.ui.launcher.OSGiLauncherTabGroup;
import org.eclipse.rap.ui.internal.launch.Activator;
import org.eclipse.rap.ui.internal.launch.tab.MainTab;

public final class RAPLaunchTabGroup
extends OSGiLauncherTabGroup {
    private static final String NEW_LINE = "\n";
    private static final String ATTR_VM_ARGUMENTS = IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS;
    private static final String JETTY_LOG_LEVEL = "-Dorg.eclipse.equinox.http.jetty.log.stderr.threshold=info";

    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        super.createTabs(dialog, mode);
        this.setTabs(RAPLaunchTabGroup.insertTab(this.getTabs(), 0, (ILaunchConfigurationTab)new MainTab()));
    }

    private static ILaunchConfigurationTab[] insertTab(ILaunchConfigurationTab[] tabs, int position, ILaunchConfigurationTab newTab) {
        ILaunchConfigurationTab[] result = new ILaunchConfigurationTab[tabs.length + 1];
        int offset = 0;
        int i = 0;
        while (i < result.length) {
            if (i == position) {
                result[i] = newTab;
                offset = -1;
            } else {
                result[i] = tabs[i + offset];
            }
            ++i;
        }
        return result;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        String vmArguments = "";
        try {
            vmArguments = config.getAttribute(ATTR_VM_ARGUMENTS, "");
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        vmArguments = RAPLaunchTabGroup.appendJettyLogLevel(vmArguments);
        config.setAttribute(ATTR_VM_ARGUMENTS, vmArguments);
    }

    private static String appendJettyLogLevel(String vmArguments) {
        String result = vmArguments;
        if (result.length() > 0) {
            result = String.valueOf(result) + NEW_LINE;
        }
        result = String.valueOf(result) + JETTY_LOG_LEVEL;
        return result;
    }
}

