/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.SerializableCompatibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridItemData
implements SerializableCompatibility {
    public Font defaultFont;
    public Color defaultBackground;
    public Color defaultForeground;
    public int customHeight = -1;
    public boolean expanded;
    List<GridItem> children;
    final List<CellData> cellData = new ArrayList<CellData>();

    public GridItemData(int cells) {
        int i = 0;
        while (i < Math.max(1, cells)) {
            this.cellData.add(null);
            ++i;
        }
    }

    public List<GridItem> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<GridItem>();
        }
        return this.children;
    }

    public void addCellData(int index) {
        if (index == -1) {
            this.cellData.add(null);
        } else {
            this.cellData.add(index, null);
        }
    }

    public void removeCellData(int index) {
        if (this.cellData.size() > index) {
            this.cellData.remove(index);
        }
    }

    public CellData getCellData(int index) {
        if (this.cellData.get(index) == null) {
            this.cellData.set(index, new CellData());
        }
        return this.cellData.get(index);
    }

    public void clear() {
        int index = 0;
        while (index < this.cellData.size()) {
            this.cellData.set(index, null);
            ++index;
        }
        this.defaultFont = null;
        this.defaultBackground = null;
        this.defaultForeground = null;
    }

    public static final class CellData
    implements SerializableCompatibility {
        public Font font;
        public Color background;
        public Color foreground;
        public String text = "";
        public String tooltip;
        public Image image;
        public boolean checked;
        public boolean grayed;
        public boolean checkable = true;
    }
}

