/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.progressbarkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.internal.widgets.progressbarkit.ProgressBarOperationHandler;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Widget;

public class ProgressBarLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.ProgressBar";
    private static final String[] ALLOWED_STYLES = new String[]{"SMOOTH", "HORIZONTAL", "VERTICAL", "INDETERMINATE", "BORDER"};
    static final String PROP_MINIMUM = "minimum";
    static final String PROP_MAXIMUM = "maximum";
    static final String PROP_SELECTION = "selection";
    static final String PROP_STATE = "state";
    private static final int DEFAULT_MINIMUM = 0;
    private static final int DEFAULT_MAXIMUM = 100;
    private static final int DEFAULT_SELECTION = 0;
    private static final String DEFAULT_STATE = "normal";

    public void preserveValues(Widget widget) {
        ProgressBar progressBar = (ProgressBar)widget;
        ControlLCAUtil.preserveValues(progressBar);
        WidgetLCAUtil.preserveCustomVariant(progressBar);
        WidgetLCAUtil.preserveProperty((Widget)progressBar, PROP_MINIMUM, new Integer(progressBar.getMinimum()));
        WidgetLCAUtil.preserveProperty((Widget)progressBar, PROP_MAXIMUM, new Integer(progressBar.getMaximum()));
        WidgetLCAUtil.preserveProperty((Widget)progressBar, PROP_SELECTION, new Integer(progressBar.getSelection()));
        WidgetLCAUtil.preserveProperty((Widget)progressBar, PROP_STATE, ProgressBarLCA.getState(progressBar));
    }

    public void renderInitialization(Widget widget) throws IOException {
        ProgressBar progressBar = (ProgressBar)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(progressBar, TYPE);
        remoteObject.setHandler(new ProgressBarOperationHandler(progressBar));
        remoteObject.set("parent", WidgetUtil.getId(progressBar.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(progressBar, ALLOWED_STYLES)));
    }

    public void renderChanges(Widget widget) throws IOException {
        ProgressBar pBar = (ProgressBar)widget;
        ControlLCAUtil.renderChanges(pBar);
        WidgetLCAUtil.renderCustomVariant(pBar);
        WidgetLCAUtil.renderProperty((Widget)pBar, PROP_MINIMUM, pBar.getMinimum(), 0);
        WidgetLCAUtil.renderProperty((Widget)pBar, PROP_MAXIMUM, pBar.getMaximum(), 100);
        WidgetLCAUtil.renderProperty((Widget)pBar, PROP_SELECTION, pBar.getSelection(), 0);
        WidgetLCAUtil.renderProperty((Widget)pBar, PROP_STATE, ProgressBarLCA.getState(pBar), DEFAULT_STATE);
        WidgetLCAUtil.renderClientListeners(pBar);
    }

    private static String getState(ProgressBar progressBar) {
        String result = DEFAULT_STATE;
        int state = progressBar.getState();
        if (state == 1) {
            result = "error";
        } else if (state == 4) {
            result = "paused";
        }
        return result;
    }
}

