/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.renderers.swt;

import org.eclipse.e4.ui.internal.workbench.renderers.swt.SWTRenderersMessages;
import org.eclipse.e4.ui.workbench.swt.internal.copy.StringMatcher;
import org.eclipse.e4.ui.workbench.swt.internal.copy.WorkbenchSWTMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractTableInformationControl {
    private Shell fShell;
    private Composite fComposite;
    private Text fFilterText;
    private TableViewer fTableViewer;
    private StringMatcher fStringMatcher;

    public AbstractTableInformationControl(Shell parent, int shellStyle, int controlStyle) {
        this.fShell = new Shell(parent, shellStyle);
        this.fShell.setLayout((Layout)new FillLayout());
        this.fComposite = new Composite((Composite)this.fShell, 16);
        GridLayout layout = new GridLayout(1, false);
        this.fComposite.setLayout((Layout)layout);
        this.createFilterText(this.fComposite);
        this.fTableViewer = this.createTableViewer(this.fComposite, controlStyle);
        final Table table = this.fTableViewer.getTable();
        table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 27: {
                        AbstractTableInformationControl.this.dispose();
                        break;
                    }
                    case 127: {
                        AbstractTableInformationControl.this.removeSelectedItems();
                        e.character = '\u0000';
                        e.doit = false;
                        break;
                    }
                    case 0x1000001: {
                        if (table.getSelectionIndex() != 0) break;
                        AbstractTableInformationControl.this.fFilterText.setFocus();
                        break;
                    }
                    case 0x1000002: {
                        if (table.getSelectionIndex() != table.getItemCount() - 1) break;
                        AbstractTableInformationControl.this.fFilterText.setFocus();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractTableInformationControl.this.gotoSelectedElement();
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TableItem tItem;
                if (table.getSelectionCount() < 1) {
                    return;
                }
                if (e.button == 1 && table.equals(e.getSource())) {
                    TableItem o = table.getItem(new Point(e.x, e.y));
                    TableItem selection = table.getSelection()[0];
                    if (selection.equals(o)) {
                        AbstractTableInformationControl.this.gotoSelectedElement();
                    }
                }
                if (e.button == 3 && (tItem = AbstractTableInformationControl.this.fTableViewer.getTable().getItem(new Point(e.x, e.y))) != null) {
                    Menu menu = new Menu((Control)AbstractTableInformationControl.this.fTableViewer.getTable());
                    MenuItem mItem = new MenuItem(menu, 0);
                    mItem.setText(SWTRenderersMessages.menuClose);
                    mItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            AbstractTableInformationControl.this.removeSelectedItems();
                        }
                    });
                    menu.setVisible(true);
                }
            }
        });
        this.setInfoSystemColor();
        this.installFilter();
    }

    protected void removeSelectedItems() {
        int selInd = this.fTableViewer.getTable().getSelectionIndex();
        if (this.deleteSelectedElements()) {
            return;
        }
        this.fTableViewer.refresh();
        if (selInd >= this.fTableViewer.getTable().getItemCount()) {
            selInd = this.fTableViewer.getTable().getItemCount() - 1;
        }
        if (selInd >= 0) {
            this.fTableViewer.getTable().setSelection(selInd);
        }
    }

    protected abstract TableViewer createTableViewer(Composite var1, int var2);

    public TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    protected Text createFilterText(Composite parent) {
        this.fFilterText = new Text(parent, 0);
        GridData data = new GridData();
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        this.fFilterText.setLayoutData((Object)data);
        this.fFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 13: 
                    case 0x1000050: {
                        AbstractTableInformationControl.this.gotoSelectedElement();
                        break;
                    }
                    case 0x1000002: {
                        AbstractTableInformationControl.this.fTableViewer.getTable().setFocus();
                        AbstractTableInformationControl.this.fTableViewer.getTable().setSelection(0);
                        break;
                    }
                    case 0x1000001: {
                        AbstractTableInformationControl.this.fTableViewer.getTable().setFocus();
                        AbstractTableInformationControl.this.fTableViewer.getTable().setSelection(AbstractTableInformationControl.this.fTableViewer.getTable().getItemCount() - 1);
                        break;
                    }
                    case 27: {
                        AbstractTableInformationControl.this.dispose();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        return this.fFilterText;
    }

    private void setInfoSystemColor() {
        Display display = this.fShell.getDisplay();
        this.setForegroundColor(display.getSystemColor(28));
        this.setBackgroundColor(display.getSystemColor(29));
    }

    private void installFilter() {
        this.fFilterText.setMessage(WorkbenchSWTMessages.FilteredTree_FilterMessage);
        this.fFilterText.setText("");
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                int length = text.length();
                if (length > 0 && text.charAt(length - 1) != '*') {
                    text = String.valueOf(text) + '*';
                }
                AbstractTableInformationControl.this.setMatcherString(text);
            }
        });
    }

    private void stringMatcherUpdated() {
        this.fTableViewer.getControl().setRedraw(false);
        this.fTableViewer.refresh();
        this.selectFirstMatch();
        this.fTableViewer.getControl().setRedraw(true);
    }

    private void setMatcherString(String pattern) {
        if (pattern.length() == 0) {
            this.fStringMatcher = null;
        } else {
            boolean ignoreCase = pattern.toLowerCase().equals(pattern);
            this.fStringMatcher = new StringMatcher(pattern, ignoreCase, false);
        }
        this.stringMatcherUpdated();
    }

    private StringMatcher getMatcher() {
        return this.fStringMatcher;
    }

    protected Object getSelectedElement() {
        return ((IStructuredSelection)this.fTableViewer.getSelection()).getFirstElement();
    }

    protected abstract void gotoSelectedElement();

    protected abstract boolean deleteSelectedElements();

    protected void selectFirstMatch() {
        Table table = this.fTableViewer.getTable();
        Object element = this.findElement(table.getItems());
        if (element != null) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(element), true);
        } else {
            this.fTableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private Object findElement(TableItem[] items) {
        ILabelProvider labelProvider = (ILabelProvider)this.fTableViewer.getLabelProvider();
        int i = 0;
        while (i < items.length) {
            Object element = items[i].getData();
            if (this.fStringMatcher == null) {
                return element;
            }
            if (element != null) {
                String label = labelProvider.getText(element);
                if (label == null) {
                    return null;
                }
                if (label.startsWith("*")) {
                    label = label.substring(1);
                }
                if (this.fStringMatcher.match(label)) {
                    return element;
                }
            }
            ++i;
        }
        return null;
    }

    public void setVisible(boolean visible) {
        this.fShell.setVisible(visible);
    }

    public void dispose() {
        if (this.fShell != null) {
            if (!this.fShell.isDisposed()) {
                this.fShell.dispose();
            }
            this.fShell = null;
            this.fTableViewer = null;
            this.fComposite = null;
            this.fFilterText = null;
        }
    }

    public Point computeSizeHint() {
        int tableHeight;
        Table viewerTable = this.fTableViewer.getTable();
        Point tableSize = viewerTable.computeSize(-1, -1);
        int tableMaxHeight = this.fComposite.getDisplay().getBounds().height / 2;
        ((GridData)viewerTable.getLayoutData()).heightHint = tableHeight = tableSize.y <= tableMaxHeight ? tableSize.y - viewerTable.getItemHeight() - viewerTable.getItemHeight() / 2 : tableMaxHeight;
        Point fCompSize = this.fComposite.computeSize(-1, -1);
        this.fComposite.setSize(fCompSize);
        return fCompSize;
    }

    public void setLocation(Point location) {
        Rectangle trim = this.fShell.computeTrim(0, 0, 0, 0);
        Point textLocation = this.fComposite.getLocation();
        location.x += trim.x - textLocation.x;
        location.y += trim.y - textLocation.y;
        this.fShell.setLocation(location);
    }

    public void setSize(int width, int height) {
        this.fShell.setSize(width, height);
    }

    public Shell getShell() {
        return this.fShell;
    }

    private void setForegroundColor(Color foreground) {
        this.fTableViewer.getTable().setForeground(foreground);
        this.fFilterText.setForeground(foreground);
        this.fComposite.setForeground(foreground);
    }

    private void setBackgroundColor(Color background) {
        this.fTableViewer.getTable().setBackground(background);
        this.fFilterText.setBackground(background);
        this.fComposite.setBackground(background);
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fFilterText.setFocus();
    }

    protected class NamePatternFilter
    extends ViewerFilter {
        protected NamePatternFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            StringMatcher matcher = AbstractTableInformationControl.this.getMatcher();
            if (matcher == null || !(viewer instanceof TableViewer)) {
                return true;
            }
            TableViewer tableViewer = (TableViewer)viewer;
            String matchName = ((ILabelProvider)tableViewer.getLabelProvider()).getText(element);
            if (matchName == null) {
                return false;
            }
            if (matchName.startsWith("*")) {
                matchName = matchName.substring(1);
            }
            return matcher.match(matchName);
        }
    }
}

