/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.visualization.jit.demo;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.rap.rwt.visualization.jit.HyperTree;
import org.eclipse.rap.rwt.visualization.jit.JITVisualizationWidget;
import org.eclipse.rap.rwt.visualization.jit.RGraph;
import org.eclipse.rap.rwt.visualization.jit.SpaceTree;
import org.eclipse.rap.rwt.visualization.jit.TreeMap;
import org.eclipse.rap.rwt.visualization.jit.demo.Activator;
import org.eclipse.rap.rwt.visualization.jit.demo.ApplicationWorkbenchAdvisor;
import org.eclipse.rwt.lifecycle.IEntryPoint;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public class Application
implements IEntryPoint {
    public static Listener createSelectionListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                JITVisualizationWidget widget = (JITVisualizationWidget)event.widget;
                System.out.println("Selected node id = " + widget.getSelectedNodeId());
            }
        };
    }

    public int createUI() {
        Display display = PlatformUI.createDisplay();
        PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadSampleData(String sampleFilePath) {
        StringBuffer data = new StringBuffer();
        try {
            Bundle bundle = Activator.getDefault().getBundle();
            InputStream in = FileLocator.openStream((Bundle)bundle, (IPath)new Path(sampleFilePath), (boolean)true);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            try {
                String line = null;
                while ((line = br.readLine()) != null) {
                    data.append(line).append("\n");
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                br.close();
                throw throwable;
            }
            {
                Object var6_9 = null;
                br.close();
                return data.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data.toString();
    }

    public static class HyperTreeExample
    extends ViewPart {
        private SashForm mainSash;
        protected HyperTree topTree;
        protected HyperTree bottomTree;

        public void createPartControl(Composite parent) {
            this.mainSash = new SashForm(parent, 512);
            Group group = new Group((Composite)this.mainSash, 0);
            group.setText("Default");
            group.setLayout((Layout)new GridLayout(1, false));
            Button backBtn = new Button((Composite)group, 8);
            backBtn.setText("Previous State");
            backBtn.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ HyperTreeExample this$1;
                {
                    this.this$1 = hyperTreeExample;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.topTree.previousState();
                }
            });
            backBtn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.topTree = new HyperTree((Composite)group, 2048);
            String sampleData = Application.loadSampleData("samples/hypertree.json");
            this.topTree.setJSONData(sampleData);
            this.topTree.setBackground(Display.getCurrent().getSystemColor(2));
            this.topTree.setForeground(Display.getCurrent().getSystemColor(1));
            this.topTree.addListener(13, Application.createSelectionListener());
            this.topTree.setLayoutData((Object)new GridData(4, 4, true, true));
            group = new Group((Composite)this.mainSash, 0);
            group.setText("Weighted");
            group.setLayout((Layout)new GridLayout(1, false));
            backBtn = new Button((Composite)group, 8);
            backBtn.setText("Previous State");
            backBtn.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ HyperTreeExample this$1;
                {
                    this.this$1 = hyperTreeExample;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.bottomTree.previousState();
                }
            });
            backBtn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.bottomTree = new HyperTree((Composite)group, 2048);
            sampleData = Application.loadSampleData("samples/hypertree-weighted.json");
            this.bottomTree.setJSONData(sampleData);
            this.bottomTree.setBackground(Display.getCurrent().getSystemColor(2));
            this.bottomTree.setForeground(Display.getCurrent().getSystemColor(7));
            this.bottomTree.setNodeColor(Display.getCurrent().getSystemColor(9).getRGB());
            this.bottomTree.setEdgeColor(new RGB(51, 34, 102));
            this.bottomTree.addListener(13, Application.createSelectionListener());
            this.bottomTree.setLayoutData((Object)new GridData(4, 4, true, true));
        }

        public void setFocus() {
            this.topTree.setFocus();
        }
    }

    public static class RGraphExample
    extends ViewPart {
        private RGraph viz;

        public void createPartControl(Composite parent) {
            this.viz = new RGraph(parent, 2048);
            String sampleData = Application.loadSampleData("samples/rgraph.json");
            this.viz.setJSONData(sampleData);
            this.viz.setBackground(Display.getCurrent().getSystemColor(2));
            this.viz.setForeground(Display.getCurrent().getSystemColor(1));
            this.viz.setNodeColor(Display.getCurrent().getSystemColor(9).getRGB());
            this.viz.addListener(13, Application.createSelectionListener());
        }

        public void setFocus() {
            this.viz.setFocus();
        }
    }

    public static class SpaceTreeExample
    extends ViewPart {
        private SpaceTree viz;

        public void createPartControl(Composite parent) {
            this.viz = new SpaceTree(parent, 2048);
            String sampleData = Application.loadSampleData("samples/spacetree.json");
            this.viz.setJSONData(sampleData);
            this.viz.setProperty("orientation", (Object)"top");
            this.viz.setEdgeProperty("type", (Object)"bezier");
            this.viz.setBackground(Display.getCurrent().getSystemColor(2));
            this.viz.addListener(13, Application.createSelectionListener());
        }

        public void setFocus() {
            this.viz.setFocus();
        }
    }

    public static class TreeMapExample
    extends ViewPart {
        private SashForm oneSash;
        private SashForm twoSash;
        private TreeMap sqViz;
        private TreeMap sliceViz;
        private TreeMap stripViz;
        private int seedId = 0;

        public void createPartControl(Composite parent) {
            String sampleData = Application.loadSampleData("samples/treemap.json");
            this.oneSash = new SashForm(parent, 512);
            this.twoSash = new SashForm((Composite)this.oneSash, 256);
            Group group = new Group((Composite)this.twoSash, 0);
            group.setText("Squarified");
            group.setLayout((Layout)new FillLayout());
            this.sqViz = new TreeMap((Composite)group, 1, 2048);
            this.sqViz.setJSONData(this.makeUnique(sampleData));
            this.sqViz.setBackground(Display.getCurrent().getSystemColor(2));
            this.sqViz.addListener(13, Application.createSelectionListener());
            group = new Group((Composite)this.twoSash, 0);
            group.setText("Strip");
            group.setLayout((Layout)new FillLayout());
            this.stripViz = new TreeMap((Composite)group, 2, 2048);
            this.stripViz.setJSONData(this.makeUnique(sampleData));
            this.stripViz.setBackground(Display.getCurrent().getSystemColor(2));
            this.stripViz.addListener(13, Application.createSelectionListener());
            group = new Group((Composite)this.oneSash, 0);
            group.setText("Slice and Dice");
            group.setLayout((Layout)new FillLayout());
            this.sliceViz = new TreeMap((Composite)group, 0, 2048);
            this.sliceViz.setJSONData(this.makeUnique(sampleData));
            this.sliceViz.setBackground(Display.getCurrent().getSystemColor(2));
            this.sliceViz.addListener(13, Application.createSelectionListener());
        }

        public void setFocus() {
            this.oneSash.setFocus();
        }

        public String makeUnique(String srcJSON) {
            String[] split = srcJSON.split("\"id\" : .*,");
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < split.length) {
                sb.append(split[i]);
                if (i + 1 < split.length) {
                    ++this.seedId;
                    sb.append("\"id\" : ").append("\"").append(this.seedId).append("\"").append(",");
                }
                ++i;
            }
            return sb.toString();
        }
    }
}

