/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.rap.addons.fileupload.DiskFileUploadReceiver;
import org.eclipse.rap.addons.fileupload.FileUploadEvent;
import org.eclipse.rap.addons.fileupload.FileUploadHandler;
import org.eclipse.rap.addons.fileupload.FileUploadListener;
import org.eclipse.rap.rwt.widgets.FileUpload;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.widgets.ProgressCollector;
import org.eclipse.swt.internal.widgets.UploadPanel;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploadRunnable
implements Runnable {
    private final Display display;
    private final FileUpload fileUpload;
    private final UploadPanel uploadPanel;
    private final ProgressCollector progressCollector;
    private final FileUploadHandler handler;
    private final AtomicReference<State> state;
    private final Object lock;

    public FileUploadRunnable(FileUpload fileUpload, UploadPanel uploadPanel, ProgressCollector progressCollector, FileUploadHandler handler) {
        this.fileUpload = fileUpload;
        this.uploadPanel = uploadPanel;
        this.progressCollector = progressCollector;
        this.handler = handler;
        this.display = fileUpload.getDisplay();
        this.lock = new Object();
        this.state = new AtomicReference<State>(State.WAITING);
        this.setupFileUploadHandler(handler, fileUpload);
        uploadPanel.updateIcons(State.WAITING);
    }

    @Override
    public void run() {
        this.asyncExec(new Runnable(){

            public void run() {
                FileUploadRunnable.this.fileUpload.submit(FileUploadRunnable.this.handler.getUploadUrl());
            }
        });
        if (!this.display.isDisposed()) {
            this.doWait();
        }
        this.asyncExec(new Runnable(){

            public void run() {
                if (!FileUploadRunnable.this.fileUpload.isDisposed() && (FileUploadRunnable.this.fileUpload.getStyle() & 2) != 0) {
                    FileUploadRunnable.this.fileUpload.dispose();
                }
            }
        });
    }

    private void setupFileUploadHandler(final FileUploadHandler handler, FileUpload fileUpload) {
        final UploadProgressListener listener = new UploadProgressListener();
        handler.addUploadListener((FileUploadListener)listener);
        fileUpload.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                handler.removeUploadListener((FileUploadListener)listener);
                handler.dispose();
            }
        });
    }

    void handleProgress(long bytesRead, long contentLength) {
        if (this.state.compareAndSet(State.WAITING, State.UPLOADING)) {
            this.uploadPanel.updateIcons(State.UPLOADING);
        }
        double fraction = (double)bytesRead / (double)contentLength;
        int percent = (int)Math.floor(fraction * 100.0);
        this.progressCollector.updateProgress(percent);
    }

    void handleFinished(List<String> targetFileNames) {
        this.state.set(State.FINISHED);
        this.uploadPanel.updateIcons(State.FINISHED);
        this.progressCollector.resetToolTip();
        this.progressCollector.updateCompletedFiles(targetFileNames);
    }

    void handleFailed() {
        this.state.set(State.FAILED);
        this.uploadPanel.updateIcons(State.FAILED);
        this.progressCollector.resetToolTip();
    }

    State getState() {
        return this.state.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWait() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotify() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    private void asyncExec(Runnable runnable) {
        if (!this.display.isDisposed()) {
            this.display.asyncExec(runnable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        WAITING,
        UPLOADING,
        FINISHED,
        FAILED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UploadProgressListener
    implements FileUploadListener {
        private UploadProgressListener() {
        }

        public void uploadProgress(final FileUploadEvent event) {
            FileUploadRunnable.this.asyncExec(new Runnable(){

                public void run() {
                    FileUploadRunnable.this.handleProgress(event.getBytesRead(), event.getContentLength());
                }
            });
        }

        public void uploadFinished(FileUploadEvent event) {
            final List<String> targetFileNames = this.getTargetFileNames();
            FileUploadRunnable.this.asyncExec(new Runnable(){

                public void run() {
                    FileUploadRunnable.this.handleFinished(targetFileNames);
                }
            });
            FileUploadRunnable.this.doNotify();
        }

        public void uploadFailed(FileUploadEvent event) {
            FileUploadRunnable.this.asyncExec(new Runnable(){

                public void run() {
                    FileUploadRunnable.this.handleFailed();
                }
            });
            FileUploadRunnable.this.doNotify();
        }

        private List<String> getTargetFileNames() {
            File[] targetFiles;
            ArrayList<String> result = new ArrayList<String>();
            File[] fileArray = targetFiles = ((DiskFileUploadReceiver)FileUploadRunnable.this.handler.getReceiver()).getTargetFiles();
            int n = targetFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File targetFile = fileArray[n2];
                result.add(targetFile.getAbsolutePath());
                ++n2;
            }
            return result;
        }
    }
}

