/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.service.ServerPushSession;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.ExtensionValidationStrategy;
import org.eclipse.swt.internal.widgets.ImageUtil;
import org.eclipse.swt.internal.widgets.ProgressCollector;
import org.eclipse.swt.internal.widgets.UploadPanel;
import org.eclipse.swt.internal.widgets.ValidationHandler;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private static final int HORIZONTAL_DIALOG_UNIT_PER_CHAR = 4;
    private static final int BUTTON_WIDTH = 61;
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String[] fileNames = new String[0];
    String filterPath = "";
    String fileName;
    int filterIndex;
    boolean overwrite = false;
    private List<UploadPanel> uploadPanels;
    private Button okButton;
    private ProgressBar totalProgressBar;
    private Combo filterSelector;
    private Button addFileSelectorButton;
    private Composite scrollChild;
    private Composite uploadsWrapper;
    private ScrolledComposite uploadScroller;
    private boolean autoUpload;
    private boolean uploadLocked;
    private ProgressCollector progressCollector;
    private ValidationHandler validationHandler;
    private Image addImage;
    private ServerPushSession pushSession;

    public FileDialog(Shell parent) {
        this(parent, 67616);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, FileDialog.checkStyle(parent, style));
        this.checkSubclass();
        this.pushSession = new ServerPushSession();
    }

    static int checkStyle(Shell parent, int style) {
        int result = style;
        int mask = 229376;
        if ((result & 0x10000000) != 0 && ((result &= 0xEFFFFFFF) & mask) == 0) {
            result |= parent == null ? 65536 : 32768;
        }
        if ((result & mask) == 0) {
            result |= 0x10000;
        }
        if ((result & 0x2000000) == 0 && parent != null && (parent.getStyle() & 0x2000000) != 0) {
            result |= 0x2000000;
        }
        result |= 0x20;
        return result &= 0xFFFFFF7F;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public void setFilterIndex(int index) {
        this.filterIndex = index;
    }

    public void setFilterNames(String[] names) {
        this.filterNames = names;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setAutoUpload(boolean autoUpload) {
        this.autoUpload = autoUpload;
    }

    public boolean getAutoUpload() {
        return this.autoUpload;
    }

    public String open() {
        this.prepareOpen();
        this.runEventLoop(this.shell);
        return this.fileName;
    }

    protected void prepareOpen() {
        this.pushSession.start();
        this.initializeDefaults();
        this.createShell();
        this.createControls();
        this.layoutAndCenterShell();
    }

    private void initializeDefaults() {
        this.uploadPanels = new ArrayList<UploadPanel>();
        this.uploadLocked = false;
        ExtensionValidationStrategy validationStrategy = new ExtensionValidationStrategy(this.filterExtensions, this.filterIndex);
        this.validationHandler = new ValidationHandler(){

            public void updateEnablement() {
                FileDialog.this.updateEnablement();
            }
        };
        this.validationHandler.addValidationStrategy(validationStrategy);
        this.progressCollector = new ProgressCollector(this.validationHandler);
        this.validationHandler.setNumUploads(this.uploadPanels.size());
    }

    private void createShell() {
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.setText(this.getText());
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                FileDialog.this.handleShellClose();
            }
        });
    }

    private void layoutAndCenterShell() {
        Point prefSize = this.shell.computeSize(-1, -1);
        prefSize.x += 50;
        prefSize.y += 10;
        if (this.allowMultiple()) {
            prefSize.y += 100;
        }
        this.shell.setSize(prefSize);
        this.shell.setMinimumSize(prefSize);
        Rectangle parentSize = this.getParent().getBounds();
        int locationX = (parentSize.width - prefSize.x) / 2 + parentSize.x;
        int locationY = (parentSize.height - prefSize.y) / 2 + parentSize.y;
        this.shell.setLocation(locationX, locationY);
    }

    private void createControls() {
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginWidth = 10;
        mainLayout.marginHeight = 10;
        mainLayout.horizontalSpacing = 10;
        mainLayout.verticalSpacing = 10;
        this.shell.setLayout((Layout)mainLayout);
        this.createDialogArea((Composite)this.shell);
        this.createButtonArea((Composite)this.shell);
    }

    private boolean allowMultiple() {
        return (this.getStyle() & 2) != 0;
    }

    private Control createDialogArea(Composite parentComposite) {
        Composite main = new Composite(parentComposite, 0);
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        main.setLayout((Layout)layout);
        if (this.allowMultiple()) {
            this.createMultiSelector(main);
        } else {
            this.createSingleSelector(main);
        }
        Composite footerComp = new Composite(main, 0);
        GridLayout footerLayout = new GridLayout(2, false);
        footerLayout.marginWidth = 0;
        footerLayout.marginHeight = 0;
        footerComp.setLayout((Layout)footerLayout);
        footerComp.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this.allowMultiple()) {
            this.createAddSelectorButton(this.scrollChild);
        }
        this.filterSelector = this.createFilterSelector(footerComp);
        this.filterSelector.setLayoutData((Object)new GridData(4, 4, false, false));
        this.totalProgressBar = new ProgressBar(footerComp, 65792);
        this.totalProgressBar.setLayoutData((Object)new GridData(4, 4, true, false));
        this.totalProgressBar.setToolTipText("Total upload progress");
        this.totalProgressBar.setMaximum(100);
        this.progressCollector.setProgressBar(this.totalProgressBar);
        return main;
    }

    private void createSingleSelector(Composite main) {
        UploadPanel uploadPanel = new UploadPanel(main, 2);
        uploadPanel.setValidationHandler(this.validationHandler);
        uploadPanel.setLayoutData(new GridData(4, 4, true, true));
        uploadPanel.setProgressCollector(this.progressCollector);
        uploadPanel.setAutoUpload(this.getAutoUpload());
        this.uploadPanels.add(uploadPanel);
        this.validationHandler.setNumUploads(this.uploadPanels.size());
    }

    private void createMultiSelector(Composite main) {
        this.uploadScroller = new ScrolledComposite(main, 2560);
        this.uploadScroller.setExpandHorizontal(true);
        this.uploadScroller.setExpandVertical(true);
        GridData uploadScrollerLayoutData = new GridData(4, 4, true, true);
        this.uploadScroller.setLayoutData((Object)uploadScrollerLayoutData);
        this.scrollChild = new Composite((Composite)this.uploadScroller, 0);
        GridLayout scrollChildLayout = new GridLayout(1, true);
        this.scrollChild.setLayout((Layout)scrollChildLayout);
        this.uploadsWrapper = new Composite(this.scrollChild, 0);
        GridLayout uploadWrapperLayout = new GridLayout(1, true);
        uploadWrapperLayout.marginBottom = 1;
        uploadWrapperLayout.marginWidth = 0;
        uploadWrapperLayout.marginHeight = 0;
        this.uploadsWrapper.setLayout((Layout)uploadWrapperLayout);
        this.uploadsWrapper.setLayoutData((Object)new GridData(4, 128, true, false));
        this.addUploadPanel();
        this.uploadScroller.setContent((Control)this.scrollChild);
        this.uploadScroller.setMinSize(this.scrollChild.computeSize(-1, -1));
    }

    private void createAddSelectorButton(Composite parent) {
        this.addFileSelectorButton = new Button(parent, 8);
        if (this.addImage == null) {
            this.addImage = ImageUtil.getImage(parent.getDisplay(), "add_obj.gif");
        }
        this.addFileSelectorButton.setImage(this.addImage);
        this.addFileSelectorButton.setToolTipText("Add file");
        this.addFileSelectorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final UploadPanel uploadPanel = FileDialog.this.addUploadPanel();
                FileDialog.this.progressCollector.updateTotalProgress();
                FileDialog.this.uploadScroller.setMinSize(FileDialog.this.scrollChild.computeSize(-1, -1));
                uploadPanel.setEnabled(false);
                uploadPanel.setVisible(false);
                FileDialog.this.uploadScroller.getDisplay().timerExec(10, new Runnable(){

                    public void run() {
                        uploadPanel.setEnabled(true);
                        uploadPanel.setVisible(true);
                        int scrollTop = ((FileDialog)(this).FileDialog.this).scrollChild.getSize().y - ((FileDialog)(this).FileDialog.this).uploadScroller.getClientArea().y;
                        FileDialog.this.uploadScroller.setOrigin(0, Math.max(0, scrollTop));
                    }
                });
            }
        });
    }

    private UploadPanel addUploadPanel() {
        int uploadPanelStyle = 13;
        final UploadPanel uploadPanel = new UploadPanel(this.uploadsWrapper, uploadPanelStyle);
        uploadPanel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        if (!FileDialog.this.uploadsWrapper.isDisposed()) {
                            FileDialog.this.uploadPanels.remove((Object)uploadPanel);
                            FileDialog.this.validationHandler.setNumUploads(FileDialog.this.uploadPanels.size());
                            FileDialog.this.scrollChild.pack(true);
                            FileDialog.this.progressCollector.updateTotalProgress();
                            FileDialog.this.uploadScroller.setMinSize(FileDialog.this.scrollChild.computeSize(-1, -1));
                            FileDialog.this.updateEnablement();
                        }
                    }
                });
            }
        });
        uploadPanel.setValidationHandler(this.validationHandler);
        uploadPanel.setLayoutData(new GridData(4, 4, true, true));
        uploadPanel.setProgressCollector(this.progressCollector);
        uploadPanel.setAutoUpload(this.getAutoUpload());
        this.uploadPanels.add(uploadPanel);
        this.validationHandler.setNumUploads(this.uploadPanels.size());
        this.scrollChild.pack(true);
        this.updateEnablement();
        return uploadPanel;
    }

    private Combo createFilterSelector(Composite headerComp) {
        final Combo filterCombo = new Combo(headerComp, 12);
        filterCombo.setToolTipText("Selected filename filter");
        String[] names = this.getFilterNames();
        String[] exts = this.getFilterExtensions();
        if (!(names != null && names.length != 0 || exts != null && exts.length != 0)) {
            names = new String[]{"All Files"};
            exts = new String[]{"*.*"};
        }
        int i = 0;
        while (i < exts.length) {
            StringBuffer sb = new StringBuffer();
            if (names != null && i < names.length) {
                sb.append(names[i]).append(" ");
            }
            sb.append("(");
            sb.append(exts[i]);
            sb.append(")");
            filterCombo.add(sb.toString());
            ++i;
        }
        filterCombo.select(this.getFilterIndex());
        filterCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog.this.setFilterIndex(filterCombo.getSelectionIndex());
                int i = 0;
                while (i < FileDialog.this.uploadPanels.size()) {
                    UploadPanel panel = (UploadPanel)((Object)FileDialog.this.uploadPanels.get(i));
                    panel.validate();
                    ++i;
                }
            }
        });
        return filterCombo;
    }

    private void createButtonArea(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridData layoutData = new GridData(131072, 0x1000000, false, false);
        layoutData.horizontalSpan = 2;
        buttonComposite.setLayoutData((Object)layoutData);
        GridLayout buttonCompLayout = new GridLayout(2, false);
        buttonCompLayout.marginWidth = 0;
        buttonCompLayout.marginHeight = 0;
        buttonComposite.setLayout((Layout)buttonCompLayout);
        String okText = SWT.getMessage((String)"SWT_OK");
        this.okButton = this.createButton(buttonComposite, okText);
        parent.getShell().setDefaultButton(this.okButton);
        this.okButton.forceFocus();
        String cancelText = SWT.getMessage((String)"SWT_Cancel");
        Button cancelButton = this.createButton(buttonComposite, cancelText);
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog.this.startUploads();
            }
        });
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog.this.closeShell();
            }
        });
        this.updateEnablement();
    }

    private void closeShell() {
        this.shell.close();
    }

    private Button createButton(Composite parent, String text) {
        Button result = new Button(parent, 8);
        result.setText(text);
        GridData data = new GridData(256);
        Font dialogFont = result.getFont();
        float charWidth = TextSizeUtil.getAvgCharWidth((Font)dialogFont);
        float width = charWidth * 61.0f + 2.0f;
        int widthHint = (int)(width / 4.0f);
        Point minSize = result.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        result.setLayoutData((Object)data);
        return result;
    }

    private void startUploads() {
        UploadPanel panel;
        ArrayList<UploadPanel> needsProcessing = new ArrayList<UploadPanel>();
        int i = 0;
        while (i < this.uploadPanels.size()) {
            panel = this.uploadPanels.get(i);
            if (!panel.isFinished()) {
                needsProcessing.add(panel);
            }
            ++i;
        }
        this.uploadLocked = true;
        if (needsProcessing.size() > 0) {
            this.okButton.setText("Uploading...");
            this.okButton.setToolTipText("Waiting for uploads to finish");
            this.okButton.setEnabled(false);
            if (this.addFileSelectorButton != null) {
                this.addFileSelectorButton.setEnabled(false);
            }
            i = 0;
            while (i < needsProcessing.size()) {
                panel = (UploadPanel)((Object)needsProcessing.get(i));
                if (!panel.isStarted()) {
                    panel.startUpload();
                }
                panel.setEnabled(false);
                ++i;
            }
        }
        this.updateEnablement();
    }

    private void updateEnablement() {
        if (this.okButton != null && !this.okButton.isDisposed()) {
            String okText = SWT.getMessage((String)"SWT_OK");
            if (this.uploadPanels.size() == 0) {
                this.okButton.setText(okText);
                this.okButton.setEnabled(false);
            } else if (this.uploadPanels.size() > 0) {
                boolean enabled = true;
                if (this.uploadLocked) {
                    if (this.progressCollector.isFinished()) {
                        this.okButton.setText(okText);
                        this.fileNames = new String[this.uploadPanels.size()];
                        this.fileName = null;
                        int i = 0;
                        while (i < this.uploadPanels.size()) {
                            UploadPanel uploadPanel = this.uploadPanels.get(i);
                            File uploadedFile = uploadPanel.getUploadedFile();
                            if (uploadedFile != null) {
                                this.fileNames[i] = uploadedFile.getAbsolutePath();
                            }
                            if (this.fileName == null || this.fileName.length() == 0) {
                                this.fileName = this.fileNames[0];
                            }
                            ++i;
                        }
                        this.shell.close();
                    } else {
                        this.okButton.setText("Uploading...");
                        this.okButton.setToolTipText("Waiting for uploads to finish");
                        this.okButton.setEnabled(false);
                    }
                } else {
                    this.okButton.setText(okText);
                    int i = 0;
                    while (i < this.uploadPanels.size()) {
                        UploadPanel panel = this.uploadPanels.get(i);
                        if (panel.getSelectedFilename().length() == 0) {
                            enabled = false;
                        }
                        ++i;
                    }
                    if (!enabled) {
                        this.okButton.setToolTipText("Specify files in all empty selectors to continue.");
                    } else {
                        this.okButton.setToolTipText("");
                    }
                    this.okButton.setEnabled(enabled);
                }
            }
        }
    }

    private void cleanup() {
        this.pushSession.stop();
    }

    private void handleShellClose() {
        this.cleanup();
    }
}

