/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.clientscripting;

import org.eclipse.rap.clientscripting.ClientListener;
import org.eclipse.rap.clientscripting.internal.ClientListenerUtil;
import org.eclipse.rap.rwt.internal.remote.RemoteObject;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectFactory;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.widgets.Widget;

class ClientListenerBinding {
    private static final String REMOTE_TYPE = "rwt.clientscripting.EventBinding";
    private final ClientListener listener;
    private final Widget widget;
    private final int eventType;
    private final RemoteObject remoteObject;
    private boolean disposed;

    ClientListenerBinding(ClientListener listener, Widget widget, int eventType) {
        this.listener = listener;
        this.widget = widget;
        this.eventType = eventType;
        this.remoteObject = RemoteObjectFactory.getInstance().createRemoteObject(REMOTE_TYPE);
        this.remoteObject.set("listener", listener.getRemoteId());
        this.remoteObject.set("targetObject", WidgetUtil.getId((Widget)widget));
        this.remoteObject.set("eventType", ClientListenerUtil.getEventType(eventType));
    }

    public Widget getWidget() {
        return this.widget;
    }

    public int getEventType() {
        return this.eventType;
    }

    public void dispose() {
        if (!this.disposed) {
            this.remoteObject.destroy();
        }
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (this == obj) {
            result = true;
        } else if (obj != null && this.getClass() == obj.getClass()) {
            ClientListenerBinding other = (ClientListenerBinding)obj;
            if (this.eventType == other.eventType && this.widget == other.widget && this.listener == other.listener) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.eventType;
        result = 31 * result + this.widget.hashCode();
        result = 31 * result + this.listener.hashCode();
        return result;
    }
}

