/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.clientscripting.internal;

import org.eclipse.rap.clientscripting.internal.ClientListenerBinding;
import org.eclipse.rap.clientscripting.internal.Synchronizer;
import org.eclipse.rap.rwt.Adaptable;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.IClientObjectAdapter;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientListenerBindingSynchronizer
implements Synchronizer<ClientListenerBinding> {
    private static final String TYPE = "rwt.clientscripting.EventBinding";

    @Override
    public void renderCreate(ClientListenerBinding binding, IClientObject clientObject) {
        clientObject.create(TYPE);
        clientObject.set("listener", ClientListenerBindingSynchronizer.getId(binding.getListener()));
        clientObject.set("targetObject", WidgetUtil.getId((Widget)binding.getWidget()));
        clientObject.set("eventType", ClientListenerBindingSynchronizer.getEventType(binding));
    }

    public void renderDestroy(ClientListenerBinding binding, IClientObject clientObject) {
        clientObject.destroy();
    }

    private static String getId(Adaptable object) {
        IClientObjectAdapter adapter = (IClientObjectAdapter)object.getAdapter(IClientObjectAdapter.class);
        return adapter.getId();
    }

    private static String getEventType(ClientListenerBinding binding) {
        String result = null;
        switch (binding.getEventType()) {
            case 2: {
                result = "KeyUp";
                break;
            }
            case 1: {
                result = "KeyDown";
                break;
            }
            case 15: {
                result = "FocusIn";
                break;
            }
            case 16: {
                result = "FocusOut";
                break;
            }
            case 3: {
                result = "MouseDown";
                break;
            }
            case 4: {
                result = "MouseUp";
                break;
            }
            case 6: {
                result = "MouseEnter";
                break;
            }
            case 7: {
                result = "MouseExit";
                break;
            }
            case 5: {
                result = "MouseMove";
                break;
            }
            case 8: {
                result = "MouseDoubleClick";
                break;
            }
            case 24: {
                result = "Modify";
                break;
            }
            case 25: {
                result = "Verify";
                break;
            }
            case 9: {
                result = "Paint";
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Unknown Event Type " + binding.getEventType());
        }
        return result;
    }
}

