/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.clientscripting;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.rap.clientscripting.ClientListenerBinding;
import org.eclipse.rap.clientscripting.internal.resources.ClientScriptingResources;
import org.eclipse.rap.rwt.internal.remote.RemoteObject;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectImpl;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientListener {
    private static final String REMOTE_TYPE = "rwt.clientscripting.Listener";
    public static final int KeyDown = 1;
    public static final int KeyUp = 2;
    public static final int MouseDown = 3;
    public static final int MouseUp = 4;
    public static final int MouseMove = 5;
    public static final int MouseEnter = 6;
    public static final int MouseExit = 7;
    public static final int MouseDoubleClick = 8;
    public static final int Paint = 9;
    public static final int FocusIn = 15;
    public static final int FocusOut = 16;
    public static final int Modify = 24;
    public static final int Verify = 25;
    private final RemoteObject remoteObject;
    private boolean disposed;
    private final Collection<ClientListenerBinding> bindings;

    public ClientListener(String scriptCode) {
        if (scriptCode == null) {
            throw new NullPointerException("Parameter is null: scriptCode");
        }
        ClientScriptingResources.ensure();
        this.disposed = false;
        this.bindings = new ArrayList<ClientListenerBinding>();
        this.remoteObject = RemoteObjectFactory.getInstance().createRemoteObject(REMOTE_TYPE);
        this.remoteObject.set("code", scriptCode);
    }

    public void addTo(Widget widget, int eventType) {
        if (this.disposed) {
            throw new IllegalStateException("ClientListener is disposed");
        }
        if (widget == null) {
            throw new NullPointerException("widget is null");
        }
        if (widget.isDisposed()) {
            throw new IllegalArgumentException("Widget is disposed");
        }
        ClientListenerBinding binding = new ClientListenerBinding(this, widget, eventType);
        this.addBinding(binding);
    }

    public void removeFrom(Widget widget, int eventType) {
        if (this.disposed) {
            throw new IllegalStateException("ClientListener is disposed");
        }
        if (widget == null) {
            throw new NullPointerException("widget is null");
        }
        ClientListenerBinding binding = this.findBinding(widget, eventType);
        if (binding != null) {
            binding.dispose();
        }
    }

    public void dispose() {
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    String getRemoteId() {
        return ((RemoteObjectImpl)this.remoteObject).getId();
    }

    Collection<ClientListenerBinding> getBindings() {
        return this.bindings;
    }

    ClientListenerBinding findBinding(Widget widget, int eventType) {
        for (ClientListenerBinding binding : this.bindings) {
            if (binding.getWidget() != widget || binding.getEventType() != eventType) continue;
            return binding;
        }
        return null;
    }

    private void addBinding(final ClientListenerBinding binding) {
        if (!this.bindings.contains(binding)) {
            this.bindings.add(binding);
            binding.getWidget().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    binding.dispose();
                }
            });
        }
    }
}

