/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ObjectName;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.Http11AprProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.res.StringManager;

public class Http11AprProtocol
extends AbstractHttp11Protocol {
    private static final Log log = LogFactory.getLog(Http11AprProtocol.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.coyote.http11");
    private final Http11ConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    public Http11AprProtocol() {
        this.endpoint = new AprEndpoint();
        this.cHandler = new Http11ConnectionHandler(this);
        ((AprEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(60000);
        this.setTcpNoDelay(true);
        this.setProcessorCache(-1);
    }

    public boolean getUseSendfile() {
        return ((AprEndpoint)this.endpoint).getUseSendfile();
    }

    public void setUseSendfile(boolean useSendfile) {
        ((AprEndpoint)this.endpoint).setUseSendfile(useSendfile);
    }

    public int getPollTime() {
        return ((AprEndpoint)this.endpoint).getPollTime();
    }

    public void setPollTime(int pollTime) {
        ((AprEndpoint)this.endpoint).setPollTime(pollTime);
    }

    public void setPollerSize(int pollerSize) {
        ((AprEndpoint)this.endpoint).setPollerSize(pollerSize);
    }

    public int getPollerSize() {
        return ((AprEndpoint)this.endpoint).getPollerSize();
    }

    public void setPollerThreadCount(int pollerThreadCount) {
        ((AprEndpoint)this.endpoint).setPollerThreadCount(pollerThreadCount);
    }

    public int getPollerThreadCount() {
        return ((AprEndpoint)this.endpoint).getPollerThreadCount();
    }

    public int getSendfileSize() {
        return ((AprEndpoint)this.endpoint).getSendfileSize();
    }

    public void setSendfileSize(int sendfileSize) {
        ((AprEndpoint)this.endpoint).setSendfileSize(sendfileSize);
    }

    public void setSendfileThreadCount(int sendfileThreadCount) {
        ((AprEndpoint)this.endpoint).setSendfileThreadCount(sendfileThreadCount);
    }

    public int getSendfileThreadCount() {
        return ((AprEndpoint)this.endpoint).getSendfileThreadCount();
    }

    public boolean getDeferAccept() {
        return ((AprEndpoint)this.endpoint).getDeferAccept();
    }

    public void setDeferAccept(boolean deferAccept) {
        ((AprEndpoint)this.endpoint).setDeferAccept(deferAccept);
    }

    public String getSSLProtocol() {
        return ((AprEndpoint)this.endpoint).getSSLProtocol();
    }

    public void setSSLProtocol(String SSLProtocol) {
        ((AprEndpoint)this.endpoint).setSSLProtocol(SSLProtocol);
    }

    public String getSSLPassword() {
        return ((AprEndpoint)this.endpoint).getSSLPassword();
    }

    public void setSSLPassword(String SSLPassword) {
        ((AprEndpoint)this.endpoint).setSSLPassword(SSLPassword);
    }

    public String getSSLCipherSuite() {
        return ((AprEndpoint)this.endpoint).getSSLCipherSuite();
    }

    public void setSSLCipherSuite(String SSLCipherSuite) {
        ((AprEndpoint)this.endpoint).setSSLCipherSuite(SSLCipherSuite);
    }

    public String getSSLCertificateFile() {
        return ((AprEndpoint)this.endpoint).getSSLCertificateFile();
    }

    public void setSSLCertificateFile(String SSLCertificateFile) {
        ((AprEndpoint)this.endpoint).setSSLCertificateFile(SSLCertificateFile);
    }

    public String getSSLCertificateKeyFile() {
        return ((AprEndpoint)this.endpoint).getSSLCertificateKeyFile();
    }

    public void setSSLCertificateKeyFile(String SSLCertificateKeyFile) {
        ((AprEndpoint)this.endpoint).setSSLCertificateKeyFile(SSLCertificateKeyFile);
    }

    public String getSSLCertificateChainFile() {
        return ((AprEndpoint)this.endpoint).getSSLCertificateChainFile();
    }

    public void setSSLCertificateChainFile(String SSLCertificateChainFile) {
        ((AprEndpoint)this.endpoint).setSSLCertificateChainFile(SSLCertificateChainFile);
    }

    public String getSSLCACertificatePath() {
        return ((AprEndpoint)this.endpoint).getSSLCACertificatePath();
    }

    public void setSSLCACertificatePath(String SSLCACertificatePath) {
        ((AprEndpoint)this.endpoint).setSSLCACertificatePath(SSLCACertificatePath);
    }

    public String getSSLCACertificateFile() {
        return ((AprEndpoint)this.endpoint).getSSLCACertificateFile();
    }

    public void setSSLCACertificateFile(String SSLCACertificateFile) {
        ((AprEndpoint)this.endpoint).setSSLCACertificateFile(SSLCACertificateFile);
    }

    public String getSSLCARevocationPath() {
        return ((AprEndpoint)this.endpoint).getSSLCARevocationPath();
    }

    public void setSSLCARevocationPath(String SSLCARevocationPath) {
        ((AprEndpoint)this.endpoint).setSSLCARevocationPath(SSLCARevocationPath);
    }

    public String getSSLCARevocationFile() {
        return ((AprEndpoint)this.endpoint).getSSLCARevocationFile();
    }

    public void setSSLCARevocationFile(String SSLCARevocationFile) {
        ((AprEndpoint)this.endpoint).setSSLCARevocationFile(SSLCARevocationFile);
    }

    public String getSSLVerifyClient() {
        return ((AprEndpoint)this.endpoint).getSSLVerifyClient();
    }

    public void setSSLVerifyClient(String SSLVerifyClient) {
        ((AprEndpoint)this.endpoint).setSSLVerifyClient(SSLVerifyClient);
    }

    public int getSSLVerifyDepth() {
        return ((AprEndpoint)this.endpoint).getSSLVerifyDepth();
    }

    public void setSSLVerifyDepth(int SSLVerifyDepth) {
        ((AprEndpoint)this.endpoint).setSSLVerifyDepth(SSLVerifyDepth);
    }

    @Override
    protected String getNamePrefix() {
        return "http-apr";
    }

    static class Http11ConnectionHandler
    implements AprEndpoint.Handler {
        protected Http11AprProtocol proto;
        protected AtomicLong registerCount = new AtomicLong(0L);
        protected RequestGroupInfo global = new RequestGroupInfo();
        protected ConcurrentHashMap<Long, Http11AprProcessor> connections = new ConcurrentHashMap();
        protected ConcurrentLinkedQueue<Http11AprProcessor> recycledProcessors = new ConcurrentLinkedQueue<Http11AprProcessor>(){
            private static final long serialVersionUID = 1L;
            protected AtomicInteger size = new AtomicInteger(0);

            @Override
            public boolean offer(Http11AprProcessor processor) {
                boolean offer = Http11ConnectionHandler.this.proto.getProcessorCache() == -1 ? true : this.size.get() < Http11ConnectionHandler.this.proto.getProcessorCache();
                boolean result = false;
                if (offer && (result = super.offer(processor))) {
                    this.size.incrementAndGet();
                }
                if (!result) {
                    Http11ConnectionHandler.this.unregister(processor);
                }
                return result;
            }

            @Override
            public Http11AprProcessor poll() {
                Http11AprProcessor result = (Http11AprProcessor)super.poll();
                if (result != null) {
                    this.size.decrementAndGet();
                }
                return result;
            }

            @Override
            public void clear() {
                Http11AprProcessor next = this.poll();
                while (next != null) {
                    Http11ConnectionHandler.this.unregister(next);
                    next = this.poll();
                }
                super.clear();
                this.size.set(0);
            }
        };

        Http11ConnectionHandler(Http11AprProtocol proto) {
            this.proto = proto;
        }

        @Override
        public Object getGlobal() {
            return this.global;
        }

        @Override
        public void recycle() {
            this.recycledProcessors.clear();
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public AbstractEndpoint.Handler.SocketState event(SocketWrapper<Long> socket, SocketStatus status) {
            Http11AprProcessor processor = this.connections.get(socket.getSocket());
            AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.CLOSED;
            if (processor == null) return state;
            if (processor.comet) {
                try {
                    try {
                        state = processor.event(status);
                        return state;
                    }
                    catch (SocketException e) {
                        log.debug(sm.getString("http11protocol.proto.socketexception.debug"), e);
                        if (state != AbstractEndpoint.Handler.SocketState.LONG) {
                            this.connections.remove(socket.getSocket());
                            socket.setAsync(false);
                            processor.recycle();
                            this.recycledProcessors.offer(processor);
                            if (state != AbstractEndpoint.Handler.SocketState.OPEN) return state;
                            ((AprEndpoint)this.proto.endpoint).getPoller().add(socket.getSocket());
                            return state;
                        }
                        ((AprEndpoint)this.proto.endpoint).getCometPoller().add(socket.getSocket());
                        return state;
                    }
                    catch (IOException e) {
                        block14: {
                            log.debug(sm.getString("http11protocol.proto.ioexception.debug"), e);
                            if (state == AbstractEndpoint.Handler.SocketState.LONG) break block14;
                            this.connections.remove(socket.getSocket());
                            socket.setAsync(false);
                            processor.recycle();
                            this.recycledProcessors.offer(processor);
                            if (state != AbstractEndpoint.Handler.SocketState.OPEN) return state;
                            ((AprEndpoint)this.proto.endpoint).getPoller().add(socket.getSocket());
                            return state;
                        }
                        ((AprEndpoint)this.proto.endpoint).getCometPoller().add(socket.getSocket());
                        return state;
                    }
                    catch (Throwable e) {
                        block15: {
                            ExceptionUtils.handleThrowable(e);
                            log.error(sm.getString("http11protocol.proto.error"), e);
                            if (state == AbstractEndpoint.Handler.SocketState.LONG) break block15;
                            this.connections.remove(socket.getSocket());
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            socket.setAsync(false);
                            processor.recycle();
                            this.recycledProcessors.offer(processor);
                            if (state != AbstractEndpoint.Handler.SocketState.OPEN) return state;
                            ((AprEndpoint)this.proto.endpoint).getPoller().add(socket.getSocket());
                            return state;
                        }
                        ((AprEndpoint)this.proto.endpoint).getCometPoller().add(socket.getSocket());
                        return state;
                    }
                }
                finally {
                    if (state != AbstractEndpoint.Handler.SocketState.LONG) {
                        this.connections.remove(socket.getSocket());
                        socket.setAsync(false);
                        processor.recycle();
                        this.recycledProcessors.offer(processor);
                        if (state == AbstractEndpoint.Handler.SocketState.OPEN) {
                            ((AprEndpoint)this.proto.endpoint).getPoller().add(socket.getSocket());
                        }
                    } else {
                        ((AprEndpoint)this.proto.endpoint).getCometPoller().add(socket.getSocket());
                    }
                }
            }
            if (!processor.isAsync()) return state;
            return this.asyncDispatch(socket, status);
        }

        @Override
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Long> socket) {
            Http11AprProcessor processor = this.recycledProcessors.poll();
            try {
                AbstractEndpoint.Handler.SocketState state;
                if (processor == null) {
                    processor = this.createProcessor();
                }
                if ((state = processor.process(socket)) == AbstractEndpoint.Handler.SocketState.LONG && processor.isAsync()) {
                    state = processor.asyncPostProcess();
                }
                if (state == AbstractEndpoint.Handler.SocketState.LONG || state == AbstractEndpoint.Handler.SocketState.ASYNC_END) {
                    this.connections.put(socket.getSocket(), processor);
                    if (processor.isAsync()) {
                        socket.setAsync(true);
                    } else if (processor.comet) {
                        ((AprEndpoint)this.proto.endpoint).getCometPoller().add(socket.getSocket());
                    }
                } else {
                    processor.recycle();
                    this.recycledProcessors.offer(processor);
                }
                return state;
            }
            catch (SocketException e) {
                log.debug(sm.getString("http11protocol.proto.socketexception.debug"), e);
            }
            catch (IOException e) {
                log.debug(sm.getString("http11protocol.proto.ioexception.debug"), e);
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable(e);
                log.error(sm.getString("http11protocol.proto.error"), e);
            }
            processor.recycle();
            this.recycledProcessors.offer(processor);
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }

        @Override
        public AbstractEndpoint.Handler.SocketState asyncDispatch(SocketWrapper<Long> socket, SocketStatus status) {
            Http11AprProcessor processor = this.connections.get(socket.getSocket());
            AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.CLOSED;
            if (processor != null) {
                try {
                    try {
                        state = processor.asyncDispatch(socket, status);
                    }
                    catch (Throwable e) {
                        ExceptionUtils.handleThrowable(e);
                        log.error(sm.getString("http11protocol.proto.error"), e);
                        if (state == AbstractEndpoint.Handler.SocketState.LONG && processor.isAsync()) {
                            state = processor.asyncPostProcess();
                        }
                        if (state != AbstractEndpoint.Handler.SocketState.LONG && state != AbstractEndpoint.Handler.SocketState.ASYNC_END) {
                            this.connections.remove(socket.getSocket());
                            socket.setAsync(false);
                            processor.recycle();
                            this.recycledProcessors.offer(processor);
                            if (state == AbstractEndpoint.Handler.SocketState.OPEN) {
                                ((AprEndpoint)this.proto.endpoint).getPoller().add(socket.getSocket());
                            }
                        }
                    }
                }
                finally {
                    if (state == AbstractEndpoint.Handler.SocketState.LONG && processor.isAsync()) {
                        state = processor.asyncPostProcess();
                    }
                    if (state != AbstractEndpoint.Handler.SocketState.LONG && state != AbstractEndpoint.Handler.SocketState.ASYNC_END) {
                        this.connections.remove(socket.getSocket());
                        socket.setAsync(false);
                        processor.recycle();
                        this.recycledProcessors.offer(processor);
                        if (state == AbstractEndpoint.Handler.SocketState.OPEN) {
                            ((AprEndpoint)this.proto.endpoint).getPoller().add(socket.getSocket());
                        }
                    }
                }
            }
            return state;
        }

        protected Http11AprProcessor createProcessor() {
            Http11AprProcessor processor = new Http11AprProcessor(this.proto.getMaxHttpHeaderSize(), (AprEndpoint)this.proto.endpoint, this.proto.getMaxTrailerSize());
            processor.setAdapter(this.proto.adapter);
            processor.setMaxKeepAliveRequests(this.proto.getMaxKeepAliveRequests());
            processor.setConnectionUploadTimeout(this.proto.getConnectionUploadTimeout());
            processor.setDisableUploadTimeout(this.proto.getDisableUploadTimeout());
            processor.setCompressionMinSize(this.proto.getCompressionMinSize());
            processor.setCompression(this.proto.getCompression());
            processor.setNoCompressionUserAgents(this.proto.getNoCompressionUserAgents());
            processor.setCompressableMimeTypes(this.proto.getCompressableMimeTypes());
            processor.setRestrictedUserAgents(this.proto.getRestrictedUserAgents());
            processor.setSocketBuffer(this.proto.getSocketBuffer());
            processor.setMaxSavePostSize(this.proto.getMaxSavePostSize());
            processor.setServer(this.proto.getServer());
            processor.setClientCertProvider(this.proto.getClientCertProvider());
            this.register(processor);
            return processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void register(Http11AprProcessor processor) {
            if (this.proto.getDomain() != null) {
                Http11ConnectionHandler http11ConnectionHandler = this;
                synchronized (http11ConnectionHandler) {
                    try {
                        long count = this.registerCount.incrementAndGet();
                        final RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(this.global);
                        final ObjectName rpName = new ObjectName(String.valueOf(this.proto.getDomain()) + ":type=RequestProcessor,worker=" + this.proto.getName() + ",name=HttpRequest" + count);
                        if (log.isDebugEnabled()) {
                            log.debug("Register " + rpName);
                        }
                        if (Constants.IS_SECURITY_ENABLED) {
                            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                                @Override
                                public Void run() {
                                    try {
                                        Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                                    }
                                    catch (Exception exception) {
                                        log.warn("Error registering request");
                                    }
                                    return null;
                                }
                            });
                        } else {
                            Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                        }
                        rp.setRpName(rpName);
                    }
                    catch (Exception exception) {
                        log.warn("Error registering request");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unregister(Http11AprProcessor processor) {
            if (this.proto.getDomain() != null) {
                Http11ConnectionHandler http11ConnectionHandler = this;
                synchronized (http11ConnectionHandler) {
                    try {
                        RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(null);
                        ObjectName rpName = rp.getRpName();
                        if (log.isDebugEnabled()) {
                            log.debug("Unregister " + rpName);
                        }
                        Registry.getRegistry(null, null).unregisterComponent(rpName);
                        rp.setRpName(null);
                    }
                    catch (Exception e) {
                        log.warn("Error unregistering request", e);
                    }
                }
            }
        }
    }
}

