/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.jmx;

import java.util.List;
import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="MBean Wrapper for Server")
public class ServerMBean
extends ObjectMBean {
    private final long startupTime = System.currentTimeMillis();
    private final Server server;

    public ServerMBean(Object managedObject) {
        super(managedObject);
        this.server = (Server)managedObject;
    }

    @ManagedAttribute(value="The contexts on this server")
    public List<ContextHandler> getContexts() {
        return this.server.getDescendants(ContextHandler.class);
    }

    @ManagedAttribute(value="The startup time since January 1st, 1970 (in ms)")
    public long getStartupTime() {
        return this.startupTime;
    }
}

