/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.combokit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.combokit.ComboOperationHandler;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Widget;

public class ComboLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Combo";
    private static final String[] ALLOWED_STYLES = new String[]{"DROP_DOWN", "SIMPLE", "BORDER"};
    static final String PROP_ITEMS = "items";
    static final String PROP_TEXT = "text";
    static final String PROP_SELECTION_INDEX = "selectionIndex";
    static final String PROP_SELECTION = "selection";
    static final String PROP_TEXT_LIMIT = "textLimit";
    static final String PROP_LIST_VISIBLE = "listVisible";
    static final String PROP_EDITABLE = "editable";
    static final String PROP_VISIBLE_ITEM_COUNT = "visibleItemCount";
    static final String PROP_SELECTION_LISTENER = "Selection";
    static final String PROP_DEFAULT_SELECTION_LISTENER = "DefaultSelection";
    static final String PROP_MODIFY_LISTENER = "Modify";
    private static final String[] DEFAUT_ITEMS = new String[0];
    private static final Integer DEFAULT_SELECTION_INDEX = -1;
    private static final Point DEFAULT_SELECTION = new Point(0, 0);
    private static final int DEFAULT_VISIBLE_ITEM_COUNT = 5;

    public void preserveValues(Widget widget) {
        Combo combo = (Combo)widget;
        ControlLCAUtil.preserveValues(combo);
        WidgetLCAUtil.preserveCustomVariant(combo);
        WidgetLCAUtil.preserveProperty((Widget)combo, PROP_ITEMS, combo.getItems());
        WidgetLCAUtil.preserveProperty((Widget)combo, PROP_SELECTION_INDEX, (Object)combo.getSelectionIndex());
        WidgetLCAUtil.preserveProperty((Widget)combo, PROP_SELECTION, combo.getSelection());
        WidgetLCAUtil.preserveProperty((Widget)combo, PROP_TEXT_LIMIT, ComboLCA.getTextLimit(combo));
        WidgetLCAUtil.preserveProperty((Widget)combo, PROP_VISIBLE_ITEM_COUNT, combo.getVisibleItemCount());
        WidgetLCAUtil.preserveProperty((Widget)combo, PROP_TEXT, combo.getText());
        WidgetLCAUtil.preserveProperty((Widget)combo, PROP_LIST_VISIBLE, combo.getListVisible());
        WidgetLCAUtil.preserveProperty((Widget)combo, PROP_EDITABLE, (Object)ComboLCA.isEditable(combo));
        WidgetLCAUtil.preserveListener(combo, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(combo, 13));
        WidgetLCAUtil.preserveListener(combo, PROP_DEFAULT_SELECTION_LISTENER, EventLCAUtil.isListening(combo, 14));
        WidgetLCAUtil.preserveListener(combo, PROP_MODIFY_LISTENER, ComboLCA.hasModifyListener(combo));
    }

    public void renderInitialization(Widget widget) throws IOException {
        Combo combo = (Combo)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(combo, TYPE);
        remoteObject.setHandler(new ComboOperationHandler(combo));
        remoteObject.set("parent", WidgetUtil.getId(combo.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(combo, ALLOWED_STYLES)));
    }

    public void renderChanges(Widget widget) throws IOException {
        Combo combo = (Combo)widget;
        ControlLCAUtil.renderChanges(combo);
        WidgetLCAUtil.renderCustomVariant(combo);
        ComboLCA.renderVisibleItemCount(combo);
        ComboLCA.renderItems(combo);
        ComboLCA.renderListVisible(combo);
        ComboLCA.renderSelectionIndex(combo);
        ComboLCA.renderEditable(combo);
        ComboLCA.renderText(combo);
        ComboLCA.renderSelection(combo);
        ComboLCA.renderTextLimit(combo);
        ComboLCA.renderListenSelection(combo);
        ComboLCA.renderListenDefaultSelection(combo);
        ComboLCA.renderListenModify(combo);
        WidgetLCAUtil.renderClientListeners(combo);
    }

    private static void renderVisibleItemCount(Combo combo) {
        int defValue = 5;
        WidgetLCAUtil.renderProperty((Widget)combo, PROP_VISIBLE_ITEM_COUNT, combo.getVisibleItemCount(), defValue);
    }

    private static void renderItems(Combo combo) {
        WidgetLCAUtil.renderProperty((Widget)combo, PROP_ITEMS, combo.getItems(), DEFAUT_ITEMS);
    }

    private static void renderListVisible(Combo combo) {
        WidgetLCAUtil.renderProperty((Widget)combo, PROP_LIST_VISIBLE, combo.getListVisible(), false);
    }

    private static void renderSelectionIndex(Combo combo) {
        boolean textChanged;
        Integer newValue = combo.getSelectionIndex();
        boolean selectionChanged = WidgetLCAUtil.hasChanged(combo, PROP_SELECTION_INDEX, newValue, DEFAULT_SELECTION_INDEX);
        boolean bl = textChanged = !ComboLCA.isEditable(combo) && WidgetLCAUtil.hasChanged(combo, PROP_TEXT, combo.getText(), "");
        if (selectionChanged || textChanged) {
            RemoteObjectFactory.getRemoteObject(combo).set(PROP_SELECTION_INDEX, newValue);
        }
    }

    private static void renderEditable(Combo combo) {
        WidgetLCAUtil.renderProperty((Widget)combo, PROP_EDITABLE, ComboLCA.isEditable(combo), true);
    }

    private static void renderText(Combo combo) {
        if (ComboLCA.isEditable(combo)) {
            WidgetLCAUtil.renderProperty((Widget)combo, PROP_TEXT, combo.getText(), "");
        }
    }

    private static void renderSelection(Combo combo) {
        WidgetLCAUtil.renderProperty((Widget)combo, PROP_SELECTION, combo.getSelection(), DEFAULT_SELECTION);
    }

    private static void renderTextLimit(Combo combo) {
        WidgetLCAUtil.renderProperty((Widget)combo, PROP_TEXT_LIMIT, ComboLCA.getTextLimit(combo), null);
    }

    private static void renderListenSelection(Combo combo) {
        WidgetLCAUtil.renderListener(combo, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(combo, 13), false);
    }

    private static void renderListenDefaultSelection(Combo combo) {
        WidgetLCAUtil.renderListener(combo, PROP_DEFAULT_SELECTION_LISTENER, EventLCAUtil.isListening(combo, 14), false);
    }

    private static void renderListenModify(Combo combo) {
        WidgetLCAUtil.renderListener(combo, PROP_MODIFY_LISTENER, ComboLCA.hasModifyListener(combo), false);
    }

    private static boolean hasModifyListener(Combo combo) {
        return EventLCAUtil.isListening(combo, 24) || EventLCAUtil.isListening(combo, 25);
    }

    private static boolean isEditable(Combo combo) {
        return (combo.getStyle() & 8) == 0;
    }

    private static Integer getTextLimit(Combo combo) {
        Integer result = combo.getTextLimit();
        if (result == Integer.MAX_VALUE) {
            result = null;
        }
        return result;
    }
}

