/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.ICoolBarAdapter;
import org.eclipse.swt.internal.widgets.IItemHolderAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoolBar
extends Composite {
    CoolItem[][] items = new CoolItem[0][0];
    CoolItem[] originalItems = new CoolItem[0];
    CoolItem dragging = null;
    int mouseXOffset;
    int itemXOffset;
    boolean isLocked = false;
    boolean inDispose = false;
    static final int ROW_SPACING = 2;
    static final int CLICK_DISTANCE = 3;
    static final int DEFAULT_COOLBAR_WIDTH = 0;
    static final int DEFAULT_COOLBAR_HEIGHT = 0;
    private transient IItemHolderAdapter itemHolder;
    private transient ICoolBarAdapter coolBarAdapter;

    public CoolBar(Composite parent, int style) {
        super(parent, CoolBar.checkStyle(style));
        this.style = (style & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        CoolBar.this.onDispose(event);
                        break;
                    }
                    case 11: {
                        CoolBar.this.onResize();
                    }
                }
            }
        };
        int[] events = new int[]{12, 11};
        int i = 0;
        while (i < events.length) {
            this.addListener(events[i], listener);
            ++i;
        }
    }

    @Override
    void initState() {
        this.state &= 0xFFFFFEFF;
    }

    private static int checkStyle(int style) {
        int result = style;
        return (result |= 0x80000) & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        this.wrapItems((this.style & 0x200) != 0 ? hHint : wHint);
        boolean flat = (this.style & 0x800000) != 0;
        int row = 0;
        while (row < this.items.length) {
            int rowWidth = 0;
            int rowHeight = 0;
            int i = 0;
            while (i < this.items[row].length) {
                CoolItem item = this.items[row][i];
                rowWidth += item.preferredWidth;
                rowHeight = Math.max(rowHeight, item.preferredHeight);
                ++i;
            }
            height += rowHeight;
            if (!flat && row > 0) {
                height += 2;
            }
            width = Math.max(width, rowWidth);
            ++row;
        }
        this.wrapItems(this.getWidth());
        if (width == 0) {
            width = 0;
        }
        if (height == 0) {
            height = 0;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, width, height);
        return this.fixPoint(trim.width, trim.height);
    }

    CoolItem getGrabbedItem(int x, int y) {
        int row = 0;
        while (row < this.items.length) {
            int i = 0;
            while (i < this.items[row].length) {
                CoolItem item = this.items[row][i];
                Rectangle bounds = item.internalGetBounds();
                bounds.width = 10;
                if (bounds.x > x) break;
                if (bounds.y > y) {
                    return null;
                }
                if (bounds.contains(x, y)) {
                    return item;
                }
                ++i;
            }
            ++row;
        }
        return null;
    }

    public CoolItem getItem(int index) {
        this.checkWidget();
        CoolItem item = null;
        int sIndex = index;
        if (index < 0) {
            this.error(6);
        }
        int row = 0;
        while (row < this.items.length && item == null) {
            if (this.items[row].length > sIndex) {
                item = this.items[row][sIndex];
            } else {
                sIndex -= this.items[row].length;
            }
            ++row;
        }
        if (item == null) {
            this.error(6);
        }
        return item;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.originalItems.length;
    }

    public CoolItem[] getItems() {
        this.checkWidget();
        CoolItem[] result = new CoolItem[this.getItemCount()];
        int offset = 0;
        int row = 0;
        while (row < this.items.length) {
            System.arraycopy(this.items[row], 0, result, offset, this.items[row].length);
            offset += this.items[row].length;
            ++row;
        }
        return result;
    }

    Point findItem(CoolItem item) {
        int row = 0;
        while (row < this.items.length) {
            int i = 0;
            while (i < this.items[row].length) {
                if (this.items[row][i].equals(item)) {
                    return new Point(i, row);
                }
                ++i;
            }
            ++row;
        }
        return new Point(-1, -1);
    }

    void fixEvent(Event event) {
        if ((this.style & 0x200) != 0) {
            int tmp = event.x;
            event.x = event.y;
            event.y = tmp;
        }
    }

    Rectangle fixRectangle(int x, int y, int width, int height) {
        if ((this.style & 0x200) != 0) {
            return new Rectangle(y, x, height, width);
        }
        return new Rectangle(x, y, width, height);
    }

    Point fixPoint(int x, int y) {
        if ((this.style & 0x200) != 0) {
            return new Point(y, x);
        }
        return new Point(x, y);
    }

    public int indexOf(CoolItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        int answer = 0;
        int row = 0;
        while (row < this.items.length) {
            int i = 0;
            while (i < this.items[row].length) {
                if (this.items[row][i].equals(item)) {
                    return answer;
                }
                ++answer;
                ++i;
            }
            ++row;
        }
        return -1;
    }

    void insertItemIntoRow(CoolItem item, int rowIndex, int x_root) {
        int barWidth = this.getWidth();
        int rowY = this.items[rowIndex][0].internalGetBounds().y;
        int x = Math.max(0, x_root - this.toDisplay((Point)new Point((int)0, (int)0)).x);
        int index = 0;
        while (index < this.items[rowIndex].length) {
            if (x < this.items[rowIndex][index].internalGetBounds().x) break;
            ++index;
        }
        if (index == 0) {
            item.wrap = true;
            this.items[rowIndex][0].wrap = false;
        }
        int oldLength = this.items[rowIndex].length;
        CoolItem[] newRow = new CoolItem[oldLength + 1];
        System.arraycopy(this.items[rowIndex], 0, newRow, 0, index);
        newRow[index] = item;
        System.arraycopy(this.items[rowIndex], index, newRow, index + 1, oldLength - index);
        this.items[rowIndex] = newRow;
        if (index > 0) {
            CoolItem left = this.items[rowIndex][index - 1];
            Rectangle leftBounds = left.internalGetBounds();
            int newWidth = x - leftBounds.x;
            if (newWidth < left.internalGetMinimumWidth()) {
                x += left.internalGetMinimumWidth() - newWidth;
                newWidth = left.internalGetMinimumWidth();
            }
            left.setBounds(leftBounds.x, leftBounds.y, newWidth, leftBounds.height);
            left.requestedWidth = newWidth;
        }
        int width = 0;
        int height = item.internalGetBounds().height;
        if (index < this.items[rowIndex].length - 1) {
            CoolItem right;
            width = right.internalGetBounds().x - x;
            right = this.items[rowIndex][index + 1];
            if (width < right.internalGetMinimumWidth()) {
                this.moveRight(right, right.internalGetMinimumWidth() - width);
                width = right.internalGetBounds().x - x;
            }
            item.setBounds(x, rowY, width, height);
            if (width < item.internalGetMinimumWidth()) {
                this.moveLeft(item, item.internalGetMinimumWidth() - width);
            }
        } else {
            width = Math.max(item.internalGetMinimumWidth(), barWidth - x);
            item.setBounds(x, rowY, width, height);
            if (x + width > barWidth) {
                this.moveLeft(item, x + width - barWidth);
            }
        }
        Rectangle bounds = item.internalGetBounds();
        item.requestedWidth = bounds.width;
    }

    void createItem(CoolItem item, int index) {
        int itemCount = this.getItemCount();
        int row = 0;
        if (index < 0 || index > itemCount) {
            this.error(6);
        }
        if (this.items.length == 0) {
            this.items = new CoolItem[1][1];
            this.items[0][0] = item;
        } else {
            int i = index;
            if (index < itemCount) {
                while (i > this.items[row].length) {
                    i -= this.items[row].length;
                    ++row;
                }
            } else {
                row = this.items.length - 1;
                i = this.items[row].length;
            }
            int lastIndex = this.items[row].length - 1;
            CoolItem lastItem = this.items[row][lastIndex];
            if (lastItem.ideal) {
                Rectangle bounds = lastItem.internalGetBounds();
                bounds.width = lastItem.preferredWidth;
                bounds.height = lastItem.preferredHeight;
                lastItem.requestedWidth = lastItem.preferredWidth;
                lastItem.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
            }
            if (i == 0) {
                item.wrap = true;
                this.items[row][0].wrap = false;
            }
            int oldLength = this.items[row].length;
            CoolItem[] newRow = new CoolItem[oldLength + 1];
            System.arraycopy(this.items[row], 0, newRow, 0, i);
            newRow[i] = item;
            System.arraycopy(this.items[row], i, newRow, i + 1, oldLength - i);
            this.items[row] = newRow;
        }
        item.requestedWidth = 10;
        int length = this.originalItems.length;
        CoolItem[] newOriginals = new CoolItem[length + 1];
        System.arraycopy(this.originalItems, 0, newOriginals, 0, index);
        System.arraycopy(this.originalItems, index, newOriginals, index + 1, length - index);
        newOriginals[index] = item;
        this.originalItems = newOriginals;
        this.layoutItems();
    }

    void destroyItem(CoolItem item) {
        if (this.inDispose) {
            return;
        }
        int row = this.findItem((CoolItem)item).y;
        if (row == -1) {
            return;
        }
        this.removeItemFromRow(item, row, true);
        int index = 0;
        while (index < this.originalItems.length) {
            if (this.originalItems[index] == item) break;
            ++index;
        }
        int length = this.originalItems.length - 1;
        CoolItem[] newOriginals = new CoolItem[length];
        System.arraycopy(this.originalItems, 0, newOriginals, 0, index);
        System.arraycopy(this.originalItems, index + 1, newOriginals, index, length - index);
        this.originalItems = newOriginals;
        this.relayout();
    }

    void moveDown(CoolItem item, int x_root) {
        int oldRowIndex = this.findItem((CoolItem)item).y;
        boolean resize = false;
        if (this.items[oldRowIndex].length == 1) {
            resize = true;
            if (oldRowIndex == this.items.length - 1) {
                return;
            }
        }
        int newRowIndex = this.items[oldRowIndex].length == 1 ? oldRowIndex : oldRowIndex + 1;
        this.removeItemFromRow(item, oldRowIndex, false);
        if (newRowIndex == this.items.length) {
            CoolItem[][] newRows = new CoolItem[this.items.length + 1][];
            System.arraycopy(this.items, 0, newRows, 0, this.items.length);
            int row = this.items.length;
            newRows[row] = new CoolItem[1];
            newRows[row][0] = item;
            this.items = newRows;
            resize = true;
            item.wrap = true;
        } else {
            this.insertItemIntoRow(item, newRowIndex, x_root);
        }
        if (resize) {
            this.relayout();
        } else {
            this.layoutItems();
        }
    }

    void moveLeft(CoolItem item, int pixels) {
        Point point = this.findItem(item);
        int row = point.y;
        int index = point.x;
        if (index == 0) {
            return;
        }
        Rectangle bounds = item.internalGetBounds();
        int minSpaceOnLeft = 0;
        int i = 0;
        while (i < index) {
            minSpaceOnLeft += this.items[row][i].internalGetMinimumWidth();
            ++i;
        }
        int x = Math.max(minSpaceOnLeft, bounds.x - pixels);
        CoolItem left = this.items[row][index - 1];
        Rectangle leftBounds = left.internalGetBounds();
        if (leftBounds.x + left.internalGetMinimumWidth() > x) {
            int shift = leftBounds.x + left.internalGetMinimumWidth() - x;
            this.moveLeft(left, shift);
            leftBounds = left.internalGetBounds();
        }
        int leftWidth = Math.max(left.internalGetMinimumWidth(), leftBounds.width - pixels);
        left.setBounds(leftBounds.x, leftBounds.y, leftWidth, leftBounds.height);
        left.requestedWidth = leftWidth;
        int width = bounds.width + (bounds.x - x);
        item.setBounds(x, bounds.y, width, bounds.height);
        item.requestedWidth = width;
    }

    void moveRight(CoolItem item, int pixels) {
        Point point = this.findItem(item);
        int row = point.y;
        int index = point.x;
        if (index == 0) {
            return;
        }
        Rectangle bounds = item.internalGetBounds();
        int minSpaceOnRight = 0;
        int i = index;
        while (i < this.items[row].length) {
            minSpaceOnRight += this.items[row][i].internalGetMinimumWidth();
            ++i;
        }
        int max = this.getWidth() - minSpaceOnRight;
        int x = Math.min(max, bounds.x + pixels);
        int width = 0;
        if (index + 1 == this.items[row].length) {
            width = this.getWidth() - x;
        } else {
            CoolItem right = this.items[row][index + 1];
            Rectangle rightBounds = right.internalGetBounds();
            if (x + item.internalGetMinimumWidth() > rightBounds.x) {
                int shift = x + item.internalGetMinimumWidth() - rightBounds.x;
                this.moveRight(right, shift);
                rightBounds = right.internalGetBounds();
            }
            width = rightBounds.x - x;
        }
        item.setBounds(x, bounds.y, width, bounds.height);
        item.requestedWidth = width;
        CoolItem left = this.items[row][index - 1];
        Rectangle leftBounds = left.internalGetBounds();
        int leftWidth = x - leftBounds.x;
        left.setBounds(leftBounds.x, leftBounds.y, leftWidth, leftBounds.height);
        left.requestedWidth = leftWidth;
    }

    void moveUp(CoolItem item, int x_root) {
        Point point = this.findItem(item);
        int oldRowIndex = point.y;
        boolean resize = false;
        if (this.items[oldRowIndex].length == 1) {
            resize = true;
            if (oldRowIndex == 0) {
                return;
            }
        }
        this.removeItemFromRow(item, oldRowIndex, false);
        int newRowIndex = Math.max(0, oldRowIndex - 1);
        if (oldRowIndex == 0) {
            CoolItem[][] newRows = new CoolItem[this.items.length + 1][];
            System.arraycopy(this.items, 0, newRows, 1, this.items.length);
            newRows[0] = new CoolItem[1];
            newRows[0][0] = item;
            this.items = newRows;
            resize = true;
            item.wrap = true;
        } else {
            this.insertItemIntoRow(item, newRowIndex, x_root);
        }
        if (resize) {
            this.relayout();
        } else {
            this.layoutItems();
        }
    }

    void onDispose(Event event) {
        if (this.inDispose) {
            return;
        }
        this.inDispose = true;
        int i = 0;
        while (i < this.items.length) {
            int j = 0;
            while (j < this.items[i].length) {
                this.items[i][j].dispose();
                ++j;
            }
            ++i;
        }
    }

    void onResize() {
        this.layoutItems();
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        CoolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            CoolItem item = items[i];
            if (item.control == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    void removeItemFromRow(CoolItem item, int rowIndex, boolean disposed) {
        int index = this.findItem((CoolItem)item).x;
        int newLength = this.items[rowIndex].length - 1;
        Rectangle itemBounds = item.internalGetBounds();
        item.wrap = false;
        if (newLength <= 0) {
            CoolItem[][] newRows = new CoolItem[this.items.length - 1][];
            System.arraycopy(this.items, 0, newRows, 0, rowIndex);
            System.arraycopy(this.items, rowIndex + 1, newRows, rowIndex, newRows.length - rowIndex);
            this.items = newRows;
            return;
        }
        CoolItem[] newRow = new CoolItem[newLength];
        System.arraycopy(this.items[rowIndex], 0, newRow, 0, index);
        System.arraycopy(this.items[rowIndex], index + 1, newRow, index, newRow.length - index);
        this.items[rowIndex] = newRow;
        this.items[rowIndex][0].wrap = true;
        if (!disposed) {
            if (index == 0) {
                CoolItem first = this.items[rowIndex][0];
                Rectangle bounds = first.internalGetBounds();
                int width = bounds.x + bounds.width;
                first.setBounds(0, bounds.y, width, bounds.height);
                first.requestedWidth = width;
            } else {
                CoolItem previous = this.items[rowIndex][index - 1];
                Rectangle bounds = previous.internalGetBounds();
                int width = bounds.width + itemBounds.width;
                previous.setBounds(bounds.x, bounds.y, width, bounds.height);
                previous.requestedWidth = width;
            }
        }
    }

    int layoutItems() {
        int y = 0;
        int width = (this.style & 0x200) != 0 ? this.getClientArea().height : this.getClientArea().width;
        this.wrapItems(width);
        int rowSpacing = (this.style & 0x800000) != 0 ? 0 : 2;
        int row = 0;
        while (row < this.items.length) {
            int count = this.items[row].length;
            int x = 0;
            int rowHeight = 0;
            int available = width;
            int i = 0;
            while (i < count) {
                CoolItem item = this.items[row][i];
                rowHeight = Math.max(rowHeight, item.preferredHeight);
                available -= item.internalGetMinimumWidth();
                ++i;
            }
            if (row > 0) {
                y += rowSpacing;
            }
            i = 0;
            while (i < count) {
                Rectangle newBounds;
                Rectangle oldBounds;
                CoolItem child = this.items[row][i];
                int newWidth = available + child.internalGetMinimumWidth();
                if (i + 1 < count) {
                    newWidth = Math.min(newWidth, child.preferredWidth);
                    available -= newWidth - child.internalGetMinimumWidth();
                }
                if (!(oldBounds = child.internalGetBounds()).equals(newBounds = new Rectangle(x, y, newWidth, rowHeight))) {
                    child.setBounds(newBounds.x, newBounds.y, newBounds.width, newBounds.height);
                }
                x += newWidth;
                ++i;
            }
            y += rowHeight;
            ++row;
        }
        return y;
    }

    void relayout() {
        Point size = this.getSize();
        int height = this.layoutItems();
        if ((this.style & 0x200) != 0) {
            Rectangle trim = this.computeTrim(0, 0, height, 0);
            if (height != size.x) {
                super.setSize(trim.width, size.y);
            }
        } else {
            Rectangle trim = this.computeTrim(0, 0, 0, height);
            if (height != size.y) {
                super.setSize(size.x, trim.height);
            }
        }
    }

    public int[] getItemOrder() {
        this.checkWidget();
        int count = this.getItemCount();
        int[] indices = new int[count];
        count = 0;
        int i = 0;
        while (i < this.items.length) {
            int j = 0;
            while (j < this.items[i].length) {
                CoolItem item = this.items[i][j];
                int index = 0;
                while (index < this.originalItems.length) {
                    if (this.originalItems[index] == item) break;
                    ++index;
                }
                if (index == this.originalItems.length) {
                    this.error(8);
                }
                indices[count++] = index;
                ++j;
            }
            ++i;
        }
        return indices;
    }

    void setItemOrder(int[] itemOrder) {
        int count;
        if (itemOrder == null) {
            this.error(4);
        }
        if (itemOrder.length != (count = this.originalItems.length)) {
            this.error(5);
        }
        boolean[] set = new boolean[count];
        int i = 0;
        while (i < set.length) {
            set[i] = false;
            ++i;
        }
        i = 0;
        while (i < itemOrder.length) {
            if (itemOrder[i] < 0 || itemOrder[i] >= count) {
                this.error(5);
            }
            if (set[itemOrder[i]]) {
                this.error(5);
            }
            set[itemOrder[i]] = true;
            ++i;
        }
        CoolItem[] row = new CoolItem[count];
        int i2 = 0;
        while (i2 < count) {
            row[i2] = this.originalItems[itemOrder[i2]];
            ++i2;
        }
        this.items = new CoolItem[1][count];
        this.items[0] = row;
        this.layoutItems();
    }

    public Point[] getItemSizes() {
        this.checkWidget();
        CoolItem[] items = this.getItems();
        Point[] sizes = new Point[items.length];
        int i = 0;
        while (i < items.length) {
            sizes[i] = items[i].getSize();
            ++i;
        }
        return sizes;
    }

    void setItemSizes(Point[] sizes) {
        CoolItem[] items;
        if (sizes == null) {
            this.error(4);
        }
        if (sizes.length != (items = this.getItems()).length) {
            this.error(5);
        }
        int i = 0;
        while (i < items.length) {
            items[i].setSize(sizes[i]);
            ++i;
        }
    }

    public boolean getLocked() {
        this.checkWidget();
        return this.isLocked;
    }

    int getWidth() {
        if ((this.style & 0x200) != 0) {
            return this.getSize().y;
        }
        return this.getSize().x;
    }

    public int[] getWrapIndices() {
        this.checkWidget();
        if (this.items.length <= 1) {
            return new int[0];
        }
        int[] wrapIndices = new int[this.items.length - 1];
        int i = 0;
        int nextWrap = this.items[0].length;
        int row = 1;
        while (row < this.items.length) {
            if (this.items[row][0].wrap) {
                wrapIndices[i++] = nextWrap;
            }
            nextWrap += this.items[row].length;
            ++row;
        }
        if (i != wrapIndices.length) {
            int[] tmp = new int[i];
            System.arraycopy(wrapIndices, 0, tmp, 0, i);
            return tmp;
        }
        return wrapIndices;
    }

    public void setLocked(boolean locked) {
        this.checkWidget();
        if (this.isLocked != locked) {
            this.redraw();
        }
        this.isLocked = locked;
    }

    public void setWrapIndices(int[] indices) {
        this.checkWidget();
        int[] newIndices = indices;
        if (newIndices == null) {
            newIndices = new int[]{};
        }
        int count = this.originalItems.length;
        int i = 0;
        while (i < newIndices.length) {
            if (newIndices[i] < 0 || newIndices[i] >= count) {
                this.error(5);
            }
            ++i;
        }
        i = 0;
        while (i < this.originalItems.length) {
            this.originalItems[i].wrap = false;
            ++i;
        }
        i = 0;
        while (i < newIndices.length) {
            int index = newIndices[i];
            int row = 0;
            while (row < this.items.length) {
                if (this.items[row].length > index) {
                    this.items[row][index].wrap = true;
                    break;
                }
                index -= this.items[row].length;
                ++row;
            }
            ++i;
        }
        this.relayout();
    }

    public void setItemLayout(int[] itemOrder, int[] wrapIndices, Point[] sizes) {
        this.checkWidget();
        this.setItemOrder(itemOrder);
        this.setWrapIndices(wrapIndices);
        this.setItemSizes(sizes);
        this.relayout();
    }

    void wrapItems(int maxWidth) {
        int itemCount = this.originalItems.length;
        if (itemCount < 2) {
            return;
        }
        CoolItem[] itemsVisual = new CoolItem[itemCount];
        int start = 0;
        int row = 0;
        while (row < this.items.length) {
            System.arraycopy(this.items[row], 0, itemsVisual, start, this.items[row].length);
            start += this.items[row].length;
            ++row;
        }
        CoolItem[][] newItems = new CoolItem[itemCount][];
        int rowCount = 0;
        int rowWidth = 0;
        start = 0;
        int i = 0;
        while (i < itemCount) {
            CoolItem item = itemsVisual[i];
            int itemWidth = item.internalGetMinimumWidth();
            if (i > 0 && item.wrap || maxWidth != -1 && rowWidth + itemWidth > maxWidth) {
                if (i == start) {
                    newItems[rowCount] = new CoolItem[1];
                    newItems[rowCount][0] = item;
                    start = i + 1;
                    rowWidth = 0;
                } else {
                    int count = i - start;
                    newItems[rowCount] = new CoolItem[count];
                    System.arraycopy(itemsVisual, start, newItems[rowCount], 0, count);
                    start = i;
                    rowWidth = itemWidth;
                }
                ++rowCount;
            } else {
                rowWidth += itemWidth;
            }
            ++i;
        }
        if (start < itemCount) {
            int count = itemCount - start;
            newItems[rowCount] = new CoolItem[count];
            System.arraycopy(itemsVisual, start, newItems[rowCount], 0, count);
            ++rowCount;
        }
        if (newItems.length != rowCount) {
            CoolItem[][] tmp = new CoolItem[rowCount][];
            System.arraycopy(newItems, 0, tmp, 0, rowCount);
            this.items = tmp;
        } else {
            this.items = newItems;
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object result;
        if (adapter == IItemHolderAdapter.class) {
            if (this.itemHolder == null) {
                this.itemHolder = new CoolBarItemHolder();
            }
            result = this.itemHolder;
        } else if (adapter == ICoolBarAdapter.class) {
            if (this.coolBarAdapter == null) {
                this.coolBarAdapter = new CoolBarAdapter();
            }
            result = this.coolBarAdapter;
        } else {
            result = super.getAdapter(adapter);
        }
        return (T)result;
    }

    @Override
    void reskinChildren(int flags) {
        CoolItem[] items = this.getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                CoolItem item = items[i];
                if (item != null) {
                    item.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    private class CoolBarAdapter
    implements ICoolBarAdapter {
        private CoolBarAdapter() {
        }

        public void setItemOrder(int[] itemOrder) {
            CoolBar.this.setItemOrder(itemOrder);
        }
    }

    private class CoolBarItemHolder
    implements IItemHolderAdapter {
        private CoolBarItemHolder() {
        }

        public void add(Item item) {
        }

        public Item[] getItems() {
            return CoolBar.this.getItems();
        }

        public void insert(Item item, int index) {
        }

        public void remove(Item item) {
        }
    }
}

