/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tabfolderkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;

public class TabFolderLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.TabFolder";
    private static final String[] ALLOWED_STYLES = new String[]{"TOP", "BOTTOM", "NO_RADIO_GROUP", "BORDER"};
    private static final String PROP_SELECTION = "selection";

    public void preserveValues(Widget widget) {
        TabFolder folder = (TabFolder)widget;
        ControlLCAUtil.preserveValues(folder);
        WidgetLCAUtil.preserveCustomVariant(folder);
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_SELECTION, TabFolderLCA.getSelection(folder));
    }

    public void readData(Widget widget) {
        TabFolder folder = (TabFolder)widget;
        TabFolderLCA.processSelectionEvent(folder);
        ControlLCAUtil.processEvents(folder);
        ControlLCAUtil.processKeyEvents(folder);
        ControlLCAUtil.processMenuDetect(folder);
        WidgetLCAUtil.processHelp(widget);
    }

    public void renderInitialization(Widget widget) throws IOException {
        TabFolder folder = (TabFolder)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(folder);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(folder.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(folder, ALLOWED_STYLES));
    }

    public void renderChanges(Widget widget) throws IOException {
        TabFolder folder = (TabFolder)widget;
        ControlLCAUtil.renderChanges(folder);
        WidgetLCAUtil.renderCustomVariant(folder);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_SELECTION, TabFolderLCA.getSelection(folder), null);
    }

    private static String getSelection(TabFolder folder) {
        String selection = null;
        int selectionIndex = folder.getSelectionIndex();
        if (selectionIndex != -1) {
            selection = WidgetUtil.getId(folder.getItem(selectionIndex));
        }
        return selection;
    }

    private static void processSelectionEvent(final TabFolder folder) {
        String itemId;
        TabItem item;
        if (WidgetLCAUtil.wasEventSent(folder, "Selection") && (item = (TabItem)WidgetUtil.find(folder, itemId = WidgetLCAUtil.readEventPropertyValue(folder, "Selection", "item"))) != null) {
            ProcessActionRunner.add(new Runnable(){

                public void run() {
                    folder.setSelection(item);
                    WidgetLCAUtil.preserveProperty((Widget)folder, TabFolderLCA.PROP_SELECTION, TabFolderLCA.getSelection(folder));
                    ControlLCAUtil.processSelection(folder, item, false);
                    ControlLCAUtil.processDefaultSelection(folder, item);
                }
            });
        }
    }

    public Rectangle adjustCoordinates(Widget widget, Rectangle newBounds) {
        return new Rectangle(0, 0, newBounds.width, newBounds.height);
    }
}

