/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.sashkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Widget;

public final class SashLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Sash";
    private static final String[] ALLOWED_STYLES = new String[]{"HORIZONTAL", "VERTICAL", "SMOOTH", "BORDER"};

    public void preserveValues(Widget widget) {
        ControlLCAUtil.preserveValues((Control)widget);
        WidgetLCAUtil.preserveCustomVariant(widget);
    }

    public void readData(Widget widget) {
        Sash sash = (Sash)widget;
        SashLCA.processSelection(sash);
        ControlLCAUtil.processEvents(sash);
        ControlLCAUtil.processKeyEvents(sash);
        ControlLCAUtil.processMenuDetect(sash);
        WidgetLCAUtil.processHelp(sash);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Sash sash = (Sash)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(sash);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(sash.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(sash, ALLOWED_STYLES));
    }

    public void renderChanges(Widget widget) throws IOException {
        Sash sash = (Sash)widget;
        ControlLCAUtil.renderChanges(sash);
        WidgetLCAUtil.renderCustomVariant(sash);
    }

    private static void processSelection(Sash sash) {
        String eventName = "Selection";
        if (WidgetLCAUtil.wasEventSent(sash, eventName)) {
            String x = WidgetLCAUtil.readEventPropertyValue(sash, "Selection", "x");
            String y = WidgetLCAUtil.readEventPropertyValue(sash, "Selection", "y");
            String width = WidgetLCAUtil.readEventPropertyValue(sash, "Selection", "width");
            String height = WidgetLCAUtil.readEventPropertyValue(sash, "Selection", "height");
            Rectangle bounds = new Rectangle(Integer.parseInt(x), Integer.parseInt(y), Integer.parseInt(width), Integer.parseInt(height));
            int stateMask = EventLCAUtil.readStateMask(sash, eventName);
            String value = WidgetLCAUtil.readEventPropertyValue(sash, eventName, "detail");
            int detail = "drag".equals(value) ? 1 : 0;
            Event event = new Event();
            event.setBounds(bounds);
            event.detail = detail;
            event.stateMask = stateMask;
            sash.notifyListeners(13, event);
        }
    }
}

