/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.swt.internal.SerializableCompatibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SlimList<E>
implements List<E>,
SerializableCompatibility {
    private static final Object[] EMPTY = new Object[0];
    private Object[] data = EMPTY;

    @Override
    public boolean add(E element) {
        Object[] newData = new Object[this.data.length + 1];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        newData[this.data.length] = element;
        this.data = newData;
        return true;
    }

    @Override
    public void add(int index, E element) {
        if (index < 0 || index > this.size()) {
            String msg = "Index: " + index + ", Size: " + this.size();
            throw new IndexOutOfBoundsException(msg);
        }
        Object[] newData = new Object[this.data.length + 1];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        int length = newData.length - 1 - index;
        System.arraycopy(newData, index, newData, index + 1, length);
        newData[index] = element;
        this.data = newData;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.data = EMPTY;
    }

    @Override
    public boolean contains(Object object) {
        boolean result = false;
        int i = 0;
        while (!result && i < this.data.length) {
            result = this.data[i] == object;
            ++i;
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E get(int index) {
        return (E)this.data[index];
    }

    @Override
    public int indexOf(Object object) {
        int result = -1;
        int i = 0;
        while (result == -1 && i < this.data.length) {
            if (object == this.data[i]) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        int index = this.indexOf(object);
        if (index != -1) {
            Object[] newData = new Object[this.data.length - 1];
            System.arraycopy(this.data, 0, newData, 0, index);
            if (index < this.data.length - 1) {
                int length = this.data.length - index - 1;
                System.arraycopy(this.data, index + 1, newData, index, length);
            }
            this.data = newData;
        }
        return index != -1;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        System.arraycopy(this.data, 0, array, 0, this.data.length);
        return array;
    }
}

