/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.rap.rwt.internal.application.ApplicationContextUtil;
import org.eclipse.rap.rwt.internal.engine.PostDeserialization;
import org.eclipse.rap.rwt.internal.resources.ResourceUtil;
import org.eclipse.rap.rwt.internal.util.StreamUtil;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;

class ImageSerializer {
    private final Image image;

    ImageSerializer(Image image) {
        this.image = image;
    }

    void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(new SerializableBytes(this.getImageBytes()));
    }

    void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        SerializableBytes imageBytes = (SerializableBytes)stream.readObject();
        stream.registerValidation(new PostDeserializationValidation(imageBytes), 0);
    }

    private byte[] getImageBytes() {
        String resourceName = this.image.internalImage.getResourceName();
        InputStream inputStream = this.getResourceManager().getRegisteredContent(resourceName);
        try {
            byte[] byArray = ResourceUtil.readBinary(inputStream);
            return byArray;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            StreamUtil.close(inputStream);
        }
    }

    private UISession getUISession() {
        Display display = (Display)this.image.getDevice();
        IDisplayAdapter adapter = display.getAdapter(IDisplayAdapter.class);
        return adapter.getUISession();
    }

    private ResourceManager getResourceManager() {
        return ApplicationContextUtil.get(this.getUISession()).getResourceManager();
    }

    private class PostDeserializationValidation
    implements ObjectInputValidation {
        private final SerializableBytes imageBytes;

        PostDeserializationValidation(SerializableBytes imageBytes) {
            this.imageBytes = imageBytes;
        }

        public void validateObject() throws InvalidObjectException {
            PostDeserialization.addProcessor(ImageSerializer.this.getUISession(), new Runnable(){

                public void run() {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(((PostDeserializationValidation)PostDeserializationValidation.this).imageBytes.data);
                    ImageSerializer.this.getResourceManager().register(((ImageSerializer)((PostDeserializationValidation)PostDeserializationValidation.this).ImageSerializer.this).image.internalImage.getResourceName(), inputStream);
                }
            });
        }
    }

    private static class SerializableBytes
    implements Serializable {
        final byte[] data;

        SerializableBytes(byte[] data) {
            this.data = data;
        }
    }
}

