/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.internal.theme.IThemeAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.custom.clabelkit.CLabelThemeAdapter;
import org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter;
import org.eclipse.swt.internal.widgets.MarkupValidator;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class CLabel
extends Canvas {
    private int align = 16384;
    private int leftMargin;
    private int topMargin;
    private int rightMargin;
    private int bottomMargin;
    private String text;
    private Image image;
    private String appToolTipText;
    private Image backgroundImage;
    private Color background;
    boolean markupEnabled;
    private boolean markupValidationDisabled;

    public CLabel(Composite parent, int style) {
        super(parent, CLabel.checkStyle(style));
        int result = style;
        if ((style & 0x1020000) == 0) {
            result |= 0x4000;
        }
        if ((result & 0x1000000) != 0) {
            this.align = 0x1000000;
        }
        if ((result & 0x20000) != 0) {
            this.align = 131072;
        }
        if ((result & 0x4000) != 0) {
            this.align = 16384;
        }
        this.addDisposeListener(new LabelDisposeListener());
        this.initMargins();
    }

    private static int checkStyle(int style) {
        int result = style;
        if ((style & 0x800) != 0) {
            result |= 4;
        }
        int mask = 0x200002C;
        result = style & mask;
        return result |= 0x80000;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int borderWidth = this.getCLabelThemeAdapter().getBorderWidth(this);
        Point e = this.getTotalSize(this.image, this.text);
        if (wHint == -1) {
            e.x += this.leftMargin + this.rightMargin;
            e.x += 2 * borderWidth;
        } else {
            e.x = wHint;
        }
        if (hHint == -1) {
            e.y += this.topMargin + this.bottomMargin;
            e.y += 2 * borderWidth;
        } else {
            e.y = hHint;
        }
        return e;
    }

    public int getAlignment() {
        this.checkWidget();
        return this.align;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    private Point getTotalSize(Image image, String text) {
        Point size = new Point(0, 0);
        int spacing = this.getCLabelThemeAdapter().getSpacing(this);
        if (image != null) {
            Rectangle imageBounds = image.getBounds();
            size.x += imageBounds.width;
            size.y += imageBounds.height;
        }
        if (text != null && text.length() > 0) {
            Point extent = this.markupEnabled ? TextSizeUtil.markupExtent(this.getFont(), text, -1) : TextSizeUtil.textExtent(this.getFont(), text, -1);
            size.x += extent.x;
            size.y = Math.max(size.y, extent.y);
            if (image != null) {
                size.x += spacing;
            }
        } else {
            int charHeight = TextSizeUtil.getCharHeight(this.getFont());
            size.y = Math.max(size.y, charHeight);
        }
        return size;
    }

    public int getStyle() {
        int style = super.getStyle();
        switch (this.align) {
            case 131072: {
                style |= 0x20000;
                break;
            }
            case 0x1000000: {
                style |= 0x1000000;
                break;
            }
            case 16384: {
                style |= 0x4000;
            }
        }
        return style;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.appToolTipText;
    }

    void onDispose(DisposeEvent event) {
        this.backgroundImage = null;
        this.text = null;
        this.image = null;
        this.appToolTipText = null;
    }

    public void setAlignment(int align) {
        this.checkWidget();
        if (align != 16384 && align != 131072 && align != 0x1000000) {
            SWT.error(5);
        }
        if (this.align != align) {
            this.align = align;
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.backgroundImage == null && (color == null ? this.background == null : color.equals(this.background))) {
            return;
        }
        this.background = color;
        this.backgroundImage = null;
        this.setBackgroundGradient(null, null, false);
    }

    public void setBackground(Image image) {
        this.checkWidget();
        if (image != this.backgroundImage) {
            this.backgroundImage = image;
            if (image != null) {
                this.setBackgroundGradient(null, null, false);
            }
        }
    }

    public void setBackground(Color[] colors, int[] percents) {
        this.setBackground(colors, percents, false);
    }

    public void setBackground(Color[] colors, int[] percents, boolean vertical) {
        this.checkWidget();
        if (colors != null) {
            if (percents == null || percents.length != colors.length - 1) {
                SWT.error(5);
            }
            int i = 0;
            while (i < percents.length) {
                if (percents[i] < 0 || percents[i] > 100) {
                    SWT.error(5);
                }
                if (i > 0 && percents[i] < percents[i - 1]) {
                    SWT.error(5);
                }
                ++i;
            }
        }
        if (colors == null) {
            this.setBackgroundGradient(null, null, false);
        } else {
            Color[] gradientColors = new Color[colors.length];
            int i = 0;
            while (i < colors.length) {
                gradientColors[i] = colors[i] != null ? colors[i] : this.background;
                ++i;
            }
            int[] gradientPercents = new int[gradientColors.length];
            gradientPercents[0] = 0;
            int i2 = 1;
            while (i2 < gradientPercents.length) {
                gradientPercents[i2] = percents[i2 - 1];
                ++i2;
            }
            this.setBackgroundGradient(gradientColors, gradientPercents, vertical);
        }
        this.backgroundImage = null;
    }

    private void setBackgroundGradient(Color[] colors, int[] percents, boolean vertical) {
        IWidgetGraphicsAdapter adapter = this.getAdapter(IWidgetGraphicsAdapter.class);
        adapter.setBackgroundGradient(colors, percents, vertical);
    }

    public void setFont(Font font) {
        super.setFont(font);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != this.image) {
            this.image = image;
        }
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            this.text = "";
        } else if (!text.equals(this.text)) {
            if (this.markupEnabled && !this.markupValidationDisabled) {
                MarkupValidator.getInstance().validate(text);
            }
            this.text = text;
        }
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.appToolTipText = super.getToolTipText();
    }

    public void setMargins(int leftMargin, int topMargin, int rightMargin, int bottomMargin) {
        this.checkWidget();
        this.leftMargin = Math.max(0, leftMargin);
        this.topMargin = Math.max(0, topMargin);
        this.rightMargin = Math.max(0, rightMargin);
        this.bottomMargin = Math.max(0, bottomMargin);
    }

    public void setLeftMargin(int leftMargin) {
        this.checkWidget();
        if (leftMargin >= 0) {
            this.leftMargin = leftMargin;
        }
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setTopMargin(int topMargin) {
        this.checkWidget();
        if (topMargin >= 0) {
            this.topMargin = topMargin;
        }
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setRightMargin(int rightMargin) {
        this.checkWidget();
        if (rightMargin >= 0) {
            this.rightMargin = rightMargin;
        }
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public void setBottomMargin(int bottomMargin) {
        this.checkWidget();
        if (bottomMargin >= 0) {
            this.bottomMargin = bottomMargin;
        }
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public void setData(String key, Object value) {
        if ("org.eclipse.rap.rwt.markupEnabled".equals(key) && !this.markupEnabled) {
            this.markupEnabled = Boolean.TRUE.equals(value);
        } else if ("org.eclipse.rap.rwt.markupValidationDisabled".equals(key)) {
            this.markupValidationDisabled = Boolean.TRUE.equals(value);
        }
        super.setData(key, value);
    }

    private void initMargins() {
        Rectangle padding = this.getCLabelThemeAdapter().getPadding(this);
        this.leftMargin = padding.x;
        this.topMargin = padding.y;
        this.rightMargin = padding.width - padding.x;
        this.bottomMargin = padding.height - padding.y;
    }

    private CLabelThemeAdapter getCLabelThemeAdapter() {
        return (CLabelThemeAdapter)this.getAdapter(IThemeAdapter.class);
    }

    private class LabelDisposeListener
    implements DisposeListener,
    SerializableCompatibility {
        private LabelDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent event) {
            CLabel.this.onDispose(event);
        }
    }
}

