/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.service.WrappedRequest;
import org.eclipse.rap.rwt.service.UISession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RequestParameterBuffer {
    private static final String BUFFER = String.valueOf(RequestParameterBuffer.class.getName()) + "#buffer:-)";

    static void store(Map<String, String[]> parameters) {
        HashMap<String, String[]> buffer = new HashMap<String, String[]>(parameters);
        UISession uiSession = ContextProvider.getUISession();
        uiSession.setAttribute(BUFFER, buffer);
    }

    static void merge() {
        Map<String, String[]> bufferedParams = RequestParameterBuffer.getBufferedParameters();
        if (bufferedParams != null) {
            HttpServletRequest request = ContextProvider.getRequest();
            WrappedRequest wrappedRequest = new WrappedRequest(request, bufferedParams);
            ServiceContext context = ContextProvider.getContext();
            context.setRequest((HttpServletRequest)wrappedRequest);
        }
        ContextProvider.getUISession().removeAttribute(BUFFER);
    }

    static Map<String, String[]> getBufferedParameters() {
        return (Map)ContextProvider.getUISession().getAttribute(BUFFER);
    }

    private RequestParameterBuffer() {
    }
}

