/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.testfixture.internal.engine;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.theme.Theme;
import org.eclipse.rap.rwt.internal.theme.ThemeManager;
import org.eclipse.rap.rwt.service.ResourceLoader;

public class ThemeManagerHelper {
    private static ThemeManager themeManager;

    static {
        ThemeManagerHelper.replaceStandardResourceLoader();
    }

    public static void adaptApplicationContext(Object toAdapt) {
        if (toAdapt instanceof ApplicationContextImpl) {
            ApplicationContextImpl context = (ApplicationContextImpl)toAdapt;
            context.setThemeManager(ThemeManagerHelper.getInstance());
        }
    }

    public static void resetThemeManager() {
        if (ThemeManagerHelper.isThemeManagerAvailable()) {
            ThemeManagerHelper.doThemeManagerReset();
        }
    }

    public static void resetThemeManagerIfNeeded() {
        if (ThemeManagerHelper.isThemeManagerResetNeeded()) {
            ThemeManagerHelper.doThemeManagerReset();
        }
    }

    public static void replaceStandardResourceLoader() {
        ThemeManager.STANDARD_RESOURCE_LOADER = new TestResourceLoader();
    }

    private static ThemeManager getInstance() {
        if (themeManager == null) {
            themeManager = new TestThemeManager();
        }
        return themeManager;
    }

    private static void doThemeManagerReset() {
        TestThemeManager themeManager = (TestThemeManager)ThemeManagerHelper.getThemeManager();
        themeManager.resetInstanceInTestCases();
    }

    private static boolean isThemeManagerResetNeeded() {
        List<String> registeredThemeIds;
        boolean result = ThemeManagerHelper.isThemeManagerAvailable();
        if (result && (registeredThemeIds = Arrays.asList(ThemeManagerHelper.getThemeManager().getRegisteredThemeIds())).size() == 2) {
            result = !registeredThemeIds.contains("org.eclipse.rap.rwt.theme.Fallback") || !registeredThemeIds.contains("org.eclipse.rap.rwt.theme.Default");
        }
        return result;
    }

    private static boolean isThemeManagerAvailable() {
        return ThemeManagerHelper.getThemeManager() != null;
    }

    private static ThemeManager getThemeManager() {
        ThemeManager result = null;
        try {
            result = ContextProvider.getApplicationContext().getThemeManager();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return result;
    }

    private static class StreamBuffer
    extends BufferedInputStream {
        private StreamBuffer(InputStream in) {
            super(in);
        }

        public void close() throws IOException {
        }
    }

    private static class TestResourceLoader
    implements ResourceLoader {
        private final ClassLoader classLoader = ThemeManager.class.getClassLoader();
        private final Map<String, StreamBuffer> resourceStreams = new HashMap<String, StreamBuffer>();

        private TestResourceLoader() {
        }

        public InputStream getResourceAsStream(String name) throws IOException {
            StreamBuffer result = this.resourceStreams.get(name);
            if (!this.hasStreamBuffer(result)) {
                result = this.bufferStream(name);
            } else {
                result.reset();
            }
            return result;
        }

        private StreamBuffer bufferStream(String name) {
            StreamBuffer result = null;
            InputStream in = this.classLoader.getResourceAsStream(name);
            if (in != null) {
                result = new StreamBuffer(in);
                result.mark(Integer.MAX_VALUE);
                this.resourceStreams.put(name, result);
            }
            return result;
        }

        private boolean hasStreamBuffer(StreamBuffer result) {
            return result != null;
        }
    }

    public static class TestThemeManager
    extends ThemeManager {
        boolean initialized;
        boolean activated;
        boolean deactivated;

        public void deactivate() {
            this.deactivated = true;
        }

        public void initialize() {
            if (!this.initialized) {
                this.registerTheme(new Theme("org.eclipse.rap.rwt.theme.Default", "RAP Default Theme", null));
                this.initialized = true;
            }
        }

        public void activate() {
            if (!this.activated) {
                super.activate();
                this.activated = true;
            } else {
                ByteArrayInputStream inputStream = new ByteArrayInputStream("dummy".getBytes());
                ContextProvider.getApplicationContext().getResourceManager().register("dummy", (InputStream)inputStream);
            }
            this.deactivated = false;
        }

        public String[] getRegisteredThemeIds() {
            String[] result = new String[]{};
            if (!this.deactivated) {
                result = super.getRegisteredThemeIds();
            }
            return result;
        }

        public void resetInstanceInTestCases() {
            this.initialized = false;
            this.activated = false;
            super.deactivate();
        }
    }
}

