/*******************************************************************************
 * Copyright (c) 2002, 2012 Innoopract Informationssysteme GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Innoopract Informationssysteme GmbH - initial API and implementation
 *    EclipseSource - ongoing development
 ******************************************************************************/
package org.eclipse.swt.internal.custom.ctabitemkit;

import static org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil.preserveProperty;
import static org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil.renderProperty;

import java.io.IOException;

import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.custom.ICTabFolderAdapter;
import org.eclipse.swt.internal.widgets.IWidgetFontAdapter;
import org.eclipse.swt.widgets.Widget;


public final class CTabItemLCA extends AbstractWidgetLCA {

  private static final String TYPE = "rwt.widgets.CTabItem";
  private static final String[] ALLOWED_STYLES = new String[] { "CLOSE" };

  private static final String PROP_TEXT = "text";
  private static final String PROP_IMAGE = "image";
  private static final String PROP_SHOWING = "showing";
  private static final String PROP_SHOW_CLOSE = "showClose";

  @Override
  public void preserveValues( Widget widget ) {
    CTabItem item = ( CTabItem )widget;
    WidgetLCAUtil.preserveCustomVariant( item );
    WidgetLCAUtil.preserveToolTipText( item, item.getToolTipText() );
    WidgetLCAUtil.preserveBounds( item, item.getBounds() );
    WidgetLCAUtil.preserveFont( item, getFont( item ) );
    preserveProperty( item, PROP_TEXT, getText( item ) );
    preserveProperty( item, PROP_IMAGE, getImage( item ) );
    preserveProperty( item, PROP_SHOWING, item.isShowing() );
    preserveProperty( item, PROP_SHOW_CLOSE, item.getShowClose() );
  }

  public void readData( Widget widget ) {
  }

  @Override
  public void renderInitialization( Widget widget ) throws IOException {
    CTabItem item = ( CTabItem )widget;
    CTabFolder parent = item.getParent();
    IClientObject clientObject = ClientObjectFactory.getClientObject( item );
    clientObject.create( TYPE );
    clientObject.set( "parent", WidgetUtil.getId( parent ) );
    clientObject.set( "index", parent.indexOf( item ) );
    clientObject.set( "style", WidgetLCAUtil.getStyles( item, ALLOWED_STYLES ) );
  }

  @Override
  public void renderChanges( Widget widget ) throws IOException {
    CTabItem item = ( CTabItem )widget;
    WidgetLCAUtil.renderCustomVariant( item );
    WidgetLCAUtil.renderToolTip( item, item.getToolTipText() );
    WidgetLCAUtil.renderBounds( item, item.getBounds() );
    WidgetLCAUtil.renderFont( item, getFont( item ) );
    renderProperty( item, PROP_TEXT, getText( item ), "" );
    renderProperty( item, PROP_IMAGE, getImage( item ), null );
    renderProperty( item, PROP_SHOWING, item.isShowing(), true );
    renderProperty( item, PROP_SHOW_CLOSE, item.getShowClose(), false );
  }

  ////////////////////////////////////////////
  // Helping methods to obtain item properties

  private static String getText( CTabItem item ) {
    return getCTabFolderAdapter( item ).getShortenedItemText( item );
  }

  private static Image getImage( CTabItem item ) {
    return getCTabFolderAdapter( item ).showItemImage( item ) ? item.getImage() : null;
  }

  private static Font getFont( CTabItem item ) {
    return item.getAdapter( IWidgetFontAdapter.class ).getUserFont();
  }

  private static ICTabFolderAdapter getCTabFolderAdapter( CTabItem item ) {
    return item.getParent().getAdapter( ICTabFolderAdapter.class );
  }
}
