/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.rap.rwt.graphics.Graphics;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RowLayoutExample
implements IExamplePage {
    private boolean propCenter = false;
    private boolean propFill = false;
    private boolean propJustify = false;
    private boolean propPack = true;
    private boolean propWrap = false;
    private boolean propPrefSize = false;

    public void createControl(Composite parent) {
        parent.setLayout((Layout)ExampleUtil.createMainLayout((int)1));
        this.createLayoutArea(parent);
        this.createControlButtons(parent);
    }

    public void createLayoutArea(Composite parent) {
        SashForm sashForm = new SashForm(parent, 0);
        sashForm.setLayoutData((Object)ExampleUtil.createFillData());
        this.createLayoutComp((Composite)sashForm, 256);
        this.createLayoutComp((Composite)sashForm, 512);
    }

    private void createLayoutComp(Composite parent, int style) {
        Composite layoutCompContainer = new Composite(parent, 0);
        layoutCompContainer.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)true, (boolean)true, (boolean)true));
        String text = style == 512 ? "Vertical" : "Horizontal";
        ExampleUtil.createHeading((Composite)layoutCompContainer, (String)text, (int)1);
        Composite layoutComp = new Composite(layoutCompContainer, 2048);
        if (!this.propPrefSize) {
            layoutComp.setLayoutData((Object)ExampleUtil.createFillData());
        }
        RowLayout layout = this.createLayout(style);
        layoutComp.setLayout((Layout)layout);
        Button button1 = new Button(layoutComp, 8);
        button1.setText("Add");
        ClassLoader classLoader = this.getClass().getClassLoader();
        Image imgAdd = Graphics.getImage((String)"resources/add_obj.gif", (ClassLoader)classLoader);
        button1.setImage(imgAdd);
        Button button2 = new Button(layoutComp, 8);
        button2.setText("Remove");
        Image imgDelete = Graphics.getImage((String)"resources/delete_obj.gif", (ClassLoader)classLoader);
        button2.setImage(imgDelete);
        Button button3 = new Button(layoutComp, 8);
        button3.setText("Up");
        Image imgUp = Graphics.getImage((String)"resources/up.gif", (ClassLoader)classLoader);
        button3.setImage(imgUp);
        Button button4 = new Button(layoutComp, 8);
        button4.setText("Down");
        Image imgDown = Graphics.getImage((String)"resources/down.gif", (ClassLoader)classLoader);
        button4.setImage(imgDown);
        Button button5 = new Button(layoutComp, 8);
        button5.setText("Clear");
    }

    private void createControlButtons(final Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridData gridData = new GridData(4, 128, true, false);
        gridData.horizontalSpan = 2;
        comp.setLayoutData((Object)gridData);
        comp.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)true, (boolean)false, (boolean)false));
        final Button centerButton = new Button(comp, 32);
        centerButton.setText("Center all elements in a row");
        centerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RowLayoutExample.this.propCenter = centerButton.getSelection();
                RowLayoutExample.this.relayout(parent);
            }
        });
        final Button fillButton = new Button(comp, 32);
        fillButton.setText("Make all elements the same width / height");
        fillButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RowLayoutExample.this.propFill = fillButton.getSelection();
                RowLayoutExample.this.relayout(parent);
            }
        });
        final Button packButton = new Button(comp, 32);
        packButton.setText("Make all elements the same size");
        packButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RowLayoutExample.this.propPack = !packButton.getSelection();
                RowLayoutExample.this.relayout(parent);
            }
        });
        final Button justifyButton = new Button(comp, 32);
        justifyButton.setText("Justify elements");
        justifyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RowLayoutExample.this.propJustify = justifyButton.getSelection();
                RowLayoutExample.this.relayout(parent);
            }
        });
        final Button wrapButton = new Button(comp, 32);
        wrapButton.setText("Wrap");
        wrapButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RowLayoutExample.this.propWrap = wrapButton.getSelection();
                RowLayoutExample.this.relayout(parent);
            }
        });
        final Button preferredSizeButton = new Button(comp, 32);
        preferredSizeButton.setText("Shrink containers to their preferred size");
        preferredSizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RowLayoutExample.this.propPrefSize = preferredSizeButton.getSelection();
                RowLayoutExample.this.relayout(parent);
            }
        });
    }

    private void relayout(Composite parent) {
        Control[] children;
        Control[] controlArray = children = parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Composite) {
                Composite childComp = (Composite)child;
                this.relayout(childComp);
            }
            ++n2;
        }
        Layout layout = parent.getLayout();
        if (layout instanceof RowLayout) {
            RowLayout oldLayout = (RowLayout)layout;
            parent.setLayout((Layout)this.createLayout(oldLayout.type));
            parent.layout();
            if (!this.propPrefSize) {
                parent.setLayoutData((Object)ExampleUtil.createFillData());
            } else {
                parent.setLayoutData(null);
            }
            parent.getParent().layout();
        }
    }

    private RowLayout createLayout(int style) {
        RowLayout layout = new RowLayout(style);
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.center = this.propCenter;
        layout.fill = this.propFill;
        layout.justify = this.propJustify;
        layout.pack = this.propPack;
        layout.wrap = this.propWrap;
        return layout;
    }
}

