/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.presentation;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rap.demo.presentation.NavigationPaneContent;
import org.eclipse.rap.rwt.graphics.Graphics;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.PageBook;

public class NavigationPaneViewer
extends Composite
implements ISelectionProvider,
ISelectionChangedListener {
    private static final Color COLOR_WHITE = Graphics.getColor((int)255, (int)255, (int)255);
    private static final int BUTTON_HEIGHT = 30;
    private Label title;
    private PageBook pageBook;
    private NavigationPaneContent[] content = new NavigationPaneContent[0];
    private Composite selectorArea;
    private final Set selectionListener = new HashSet();
    private ISelection selection = StructuredSelection.EMPTY;

    public NavigationPaneViewer(Composite parent, int style, NavigationPaneContent[] content) {
        super(parent, style);
        if (content != null) {
            this.content = content;
        }
        this.createControl();
    }

    private void createControl() {
        this.setLayout((Layout)new FormLayout());
        this.createTitleArea(this);
        this.createContentArea(this);
        this.createSelectorArea(this);
    }

    private void createTitleArea(Composite parent) {
        this.title = new Label(parent, 0);
        this.title.setBackground(COLOR_WHITE);
        FontData fontData = this.title.getFont().getFontData()[0];
        Font titleFont = Graphics.getFont((String)fontData.getName(), (int)18, (int)(fontData.getStyle() | 1));
        this.title.setFont(titleFont);
        FormData fd = new FormData();
        this.title.setLayoutData((Object)fd);
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(0, 30);
        this.title.setText("Trallala");
    }

    private void createContentArea(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        FormData fd = new FormData();
        this.pageBook.setLayoutData((Object)fd);
        fd.top = new FormAttachment(0, 31);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        int bottom = -30 * (this.content.length + 1) - 1;
        fd.bottom = new FormAttachment(100, bottom);
        this.pageBook.setBackground(COLOR_WHITE);
        int i = 0;
        while (i < this.content.length) {
            this.createPage(i);
            ++i;
        }
    }

    private Control createPage(int pageIndex) {
        Composite result = new Composite((Composite)this.pageBook, 0);
        result.setBackground(COLOR_WHITE);
        result.setLayout((Layout)new FillLayout());
        this.content[pageIndex].setControl((Control)result);
        this.content[pageIndex].createControl(result);
        return result;
    }

    private void createSelectorArea(Composite parent) {
        this.selectorArea = new Composite(parent, 0);
        FormData fd = new FormData();
        this.selectorArea.setLayoutData((Object)fd);
        fd.top = new FormAttachment(100, -30 * (this.content.length + 1));
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        FillLayout fillLayout = new FillLayout(512);
        fillLayout.spacing = -1;
        this.selectorArea.setLayout((Layout)fillLayout);
        int i = 0;
        while (i < this.content.length) {
            this.createSelector(i);
            ++i;
        }
        new Label(this.selectorArea, 0);
        if (this.content.length > 0) {
            new Selector(this.content[0]).widgetSelected(null);
        }
    }

    private void createSelector(int i) {
        Button button = new Button(this.selectorArea, 0x800002);
        this.content[i].setSelector(button);
        button.setText(this.content[i].getLabel());
        button.addSelectionListener((SelectionListener)new Selector(this.content[i]));
        button.setData("org.eclipse.rap.rwt.customVariant", (Object)"mybutton");
        button.setSelection(false);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListener.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListener.remove(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection newSelection) {
        ISelection oldSelection = this.selection;
        this.selection = newSelection == null ? StructuredSelection.EMPTY : newSelection;
        if (!oldSelection.equals(this.selection)) {
            SelectionChangedEvent evt = new SelectionChangedEvent((ISelectionProvider)this, this.selection);
            Object[] listeners = this.selectionListener.toArray();
            int i = 0;
            while (i < listeners.length) {
                try {
                    ISelectionChangedListener lsnr = (ISelectionChangedListener)listeners[i];
                    lsnr.selectionChanged(evt);
                }
                catch (RuntimeException re) {
                    re.printStackTrace();
                }
                ++i;
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }

    private final class Selector
    extends SelectionAdapter {
        private final NavigationPaneContent page;

        private Selector(NavigationPaneContent page) {
            this.page = page;
        }

        public void widgetSelected(SelectionEvent e) {
            int i = 0;
            while (i < NavigationPaneViewer.this.content.length) {
                if (NavigationPaneViewer.this.content[i].isSelectionProvider()) {
                    ISelectionProvider provider = NavigationPaneViewer.this.content[i].getSelectionProvider();
                    provider.removeSelectionChangedListener((ISelectionChangedListener)NavigationPaneViewer.this);
                }
                Object selector = NavigationPaneViewer.this.content[i].getSelector();
                ((Button)selector).setSelection(NavigationPaneViewer.this.content[i] == this.page);
                ++i;
            }
            NavigationPaneViewer.this.pageBook.showPage(this.page.getControl());
            NavigationPaneViewer.this.title.setText(this.page.getLabel());
            this.page.getControl().setFocus();
            if (this.page.isSelectionProvider()) {
                ISelectionProvider provider = this.page.getSelectionProvider();
                provider.addSelectionChangedListener((ISelectionChangedListener)NavigationPaneViewer.this);
                NavigationPaneViewer.this.setSelection(provider.getSelection());
            } else {
                NavigationPaneViewer.this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        }
    }
}

