/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.intro.target;

import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.rap.ui.internal.intro.ErrorUtil;
import org.eclipse.rap.ui.internal.intro.target.IntroMessages;
import org.eclipse.rap.ui.internal.intro.target.TargetProvider;

public final class TargetSwitcher {
    private static final String WS_RAP = "rap";

    private TargetSwitcher() {
    }

    public static void switchTarget(ITargetDefinition target) throws CoreException {
        try {
            LoadTargetDefinitionJob job = new LoadTargetDefinitionJob(target);
            job.setUser(true);
            job.schedule();
            job.join();
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InterruptedException e) {
            String msg = IntroMessages.InstallRAPTargetHandler_SwitchTargetInterrupted;
            ErrorUtil.log(msg, e);
        }
    }

    public static ITargetDefinition install(String targetDefinitionURI, boolean switchTarget, IProgressMonitor monitor) throws CoreException {
        ITargetDefinition target = null;
        monitor.beginTask(IntroMessages.TargetProvider_Installing, -1);
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            SubMonitor targetMonitor = subMonitor.newChild(5);
            SubMonitor downloadMonitor = subMonitor.newChild(95);
            ITargetPlatformService targetPlatformService = TargetSwitcher.getTargetPlatformService();
            target = TargetSwitcher.createTargetDefinition(targetDefinitionURI, targetPlatformService, (IProgressMonitor)targetMonitor);
            IStatus downloadStatus = TargetSwitcher.downloadTarget(target, (IProgressMonitor)downloadMonitor);
            if (downloadStatus.isOK()) {
                TargetSwitcher.saveTarget(targetPlatformService, target);
                if (switchTarget) {
                    TargetSwitcher.switchTarget(target);
                }
            }
        }
        finally {
            monitor.done();
        }
        return target;
    }

    private static ITargetDefinition createTargetDefinition(String targetDefinitionURI, ITargetPlatformService service, IProgressMonitor monitor) throws CoreException {
        ITargetDefinition result = null;
        try {
            String localTargetDefinitionURI = TargetProvider.createLocalTargetDefinition(targetDefinitionURI, monitor);
            ITargetHandle targetHandle = service.getTarget(new URI(localTargetDefinitionURI));
            result = targetHandle.getTargetDefinition();
        }
        catch (Exception exeption) {
            String message = exeption instanceof UnknownHostException ? IntroMessages.TargetSwitcher_NoInternetConnectionAvailableErrorMsg : (exeption instanceof SocketTimeoutException ? IntroMessages.TargetSwitcher_TargetRepositoryProblemErrorMsg : IntroMessages.TargetSwitcher_TargedDefinitionErrorMessage);
            IStatus status = ErrorUtil.createErrorStatus(message, exeption);
            throw new CoreException(status);
        }
        return result;
    }

    private static IStatus downloadTarget(ITargetDefinition target, IProgressMonitor monitor) throws CoreException {
        IStatus status = target.resolve(monitor);
        if (!status.isOK()) {
            Throwable statusException = TargetSwitcher.getDownloadException(status);
            if (statusException instanceof UnknownHostException) {
                String message = IntroMessages.TargetSwitcher_NoInternetConnectionAvailableErrorMsg;
                status = ErrorUtil.createErrorStatus(message, statusException);
            } else if (statusException instanceof SocketTimeoutException) {
                String message = IntroMessages.TargetSwitcher_TargetRepositoryProblemErrorMsg;
                status = ErrorUtil.createErrorStatus(message, statusException);
            }
            throw new CoreException(status);
        }
        return status;
    }

    private static void saveTarget(ITargetPlatformService service, ITargetDefinition target) throws CoreException {
        service.saveTargetDefinition(target);
    }

    private static ITargetPlatformService getTargetPlatformService() {
        String className = ITargetPlatformService.class.getName();
        PDECore pdeCore = PDECore.getDefault();
        return (ITargetPlatformService)pdeCore.acquireService(className);
    }

    private static Throwable getDownloadException(IStatus status) {
        Throwable result = status.getException();
        IStatus[] children = status.getChildren();
        if (result == null && children != null) {
            int i = 0;
            while (i < children.length && result == null) {
                result = TargetSwitcher.getDownloadException(children[i]);
                ++i;
            }
        }
        return result;
    }
}

