/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.util;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.rap.ui.internal.launch.rwt.RWTLaunchActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public final class BundleFileLocator {
    private final Bundle bundle;

    public static String locate(String bundleSymbolicName) {
        return new BundleFileLocator(bundleSymbolicName).locate();
    }

    private BundleFileLocator(String symbolicName) {
        this.bundle = BundleFileLocator.findBundle(symbolicName);
    }

    public String locate() {
        String result = null;
        if (this.bundle != null) {
            result = this.locateExistingBundle();
        }
        return result;
    }

    private String locateExistingBundle() {
        String result = null;
        try {
            File bundleFile = FileLocator.getBundleFile((Bundle)this.bundle);
            result = bundleFile.getAbsolutePath();
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
        return result;
    }

    private void handleIOException(IOException exception) {
        String symbolicName = this.bundle.getSymbolicName();
        String msg = "Failed to obtain file location for bundle: " + symbolicName;
        throw new RuntimeException(msg, exception);
    }

    private static Bundle findBundle(String symbolicName) {
        Bundle result = null;
        Bundle[] bundles = BundleFileLocator.getAllBundles();
        int i = 0;
        while (result == null && i < bundles.length) {
            if (bundles[i].getSymbolicName().equals(symbolicName)) {
                result = bundles[i];
            }
            ++i;
        }
        return result;
    }

    private static Bundle[] getAllBundles() {
        Bundle bundle = RWTLaunchActivator.getDefault().getBundle();
        BundleContext bundleContext = bundle.getBundleContext();
        Bundle[] bundles = bundleContext.getBundles();
        return bundles;
    }
}

