/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.tab;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.rap.ui.internal.launch.rwt.config.RWTLaunchConfig;
import org.eclipse.rap.ui.internal.launch.rwt.tab.HelpContextIds;
import org.eclipse.rap.ui.internal.launch.rwt.tab.JavaProjectSelectionDialog;
import org.eclipse.rap.ui.internal.launch.rwt.tab.RWTLaunchTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProjectSection
extends RWTLaunchTab {
    private Text txtProject;
    private Button btnSelectProject;

    public String getName() {
        return "Project";
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Project");
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        this.txtProject = new Text((Composite)group, 2048);
        this.txtProject.setLayoutData((Object)new GridData(4, 128, true, false));
        this.txtProject.addModifyListener((ModifyListener)new TextModifyListener());
        this.btnSelectProject = new Button((Composite)group, 8);
        this.btnSelectProject.setText("&Browse...");
        GridData gridData = new GridData(16384, 128, false, false);
        this.btnSelectProject.setLayoutData((Object)gridData);
        this.btnSelectProject.addSelectionListener((SelectionListener)new JavaProjectSelectionListener());
        this.setControl((Control)group);
        HelpContextIds.assign(this.getControl(), HelpContextIds.MAIN_TAB);
    }

    public void initializeFrom(RWTLaunchConfig launchConfig) {
        this.txtProject.setText(launchConfig.getProjectName());
    }

    public void performApply(RWTLaunchConfig launchConfig) {
        launchConfig.setProjectName(this.txtProject.getText().trim());
    }

    private void handleSelectJavaProject() {
        IJavaProject project = this.selectJavaProject();
        if (project != null) {
            String projectName = project.getElementName();
            this.txtProject.setText(projectName);
        }
    }

    private IJavaProject selectJavaProject() {
        Shell shell = this.getShell();
        JavaProjectSelectionDialog dialog = new JavaProjectSelectionDialog(shell);
        dialog.setInitialSelection(this.getJavaProject());
        return dialog.open();
    }

    private IJavaProject getJavaProject() {
        IJavaProject result = null;
        String projectName = this.txtProject.getText().trim();
        if (projectName.length() > 0) {
            result = ProjectSection.getJavaModel().getJavaProject(projectName);
        }
        return result;
    }

    private static IJavaModel getJavaModel() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        return JavaCore.create((IWorkspaceRoot)workspaceRoot);
    }

    private class JavaProjectSelectionListener
    extends SelectionAdapter {
        private JavaProjectSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            ProjectSection.this.handleSelectJavaProject();
            ProjectSection.this.updateLaunchConfigurationDialog();
        }
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent event) {
            ProjectSection.this.updateLaunchConfigurationDialog();
        }
    }
}

